/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLScriptElement.h"

#include "HTMLNames.h"
#include "HTMLScriptElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLScriptElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLScriptElementTableValues[] =
{
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementText), (intptr_t)setJSHTMLScriptElementText THUNK_GENERATOR(0) },
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementHtmlFor), (intptr_t)setJSHTMLScriptElementHtmlFor THUNK_GENERATOR(0) },
    { "event", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementEvent), (intptr_t)setJSHTMLScriptElementEvent THUNK_GENERATOR(0) },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementCharset), (intptr_t)setJSHTMLScriptElementCharset THUNK_GENERATOR(0) },
    { "async", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementAsync), (intptr_t)setJSHTMLScriptElementAsync THUNK_GENERATOR(0) },
    { "defer", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementDefer), (intptr_t)setJSHTMLScriptElementDefer THUNK_GENERATOR(0) },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementSrc), (intptr_t)setJSHTMLScriptElementSrc THUNK_GENERATOR(0) },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementType), (intptr_t)setJSHTMLScriptElementType THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementTable = { 32, 31, JSHTMLScriptElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLScriptElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementConstructorTable = { 1, 0, JSHTMLScriptElementConstructorTableValues, 0 };
class JSHTMLScriptElementConstructor : public DOMConstructorObject {
private:
    JSHTMLScriptElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLScriptElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLScriptElementConstructor* ptr = new (JSC::allocateCell<JSHTMLScriptElementConstructor>(*exec->heap())) JSHTMLScriptElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLScriptElementConstructor::s_info = { "HTMLScriptElementConstructor", &DOMConstructorObject::s_info, &JSHTMLScriptElementConstructorTable, 0 };

JSHTMLScriptElementConstructor::JSHTMLScriptElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLScriptElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, JSDOMWrapper>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLScriptElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLScriptElementConstructor, JSDOMWrapper>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLScriptElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementPrototypeTable = { 1, 0, JSHTMLScriptElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLScriptElementPrototype::s_info = { "HTMLScriptElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLScriptElementPrototypeTable, 0 };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLScriptElement>(exec, globalObject);
}

const ClassInfo JSHTMLScriptElement::s_info = { "HTMLScriptElement", &JSHTMLElement::s_info, &JSHTMLScriptElementTable, 0 };

JSHTMLScriptElement::JSHTMLScriptElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLScriptElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLScriptElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLScriptElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLScriptElementPrototype::create(exec->globalData(), globalObject, JSHTMLScriptElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, slot);
}

bool JSHTMLScriptElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLScriptElementText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->text());
    return result;
}


JSValue jsHTMLScriptElementHtmlFor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::forAttr));
    return result;
}


JSValue jsHTMLScriptElementEvent(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::eventAttr));
    return result;
}


JSValue jsHTMLScriptElementCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}


JSValue jsHTMLScriptElementAsync(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->async());
    return result;
}


JSValue jsHTMLScriptElementDefer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::deferAttr));
    return result;
}


JSValue jsHTMLScriptElementSrc(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLScriptElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLScriptElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLScriptElement* domObject = static_cast<JSHTMLScriptElement*>(asObject(slotBase));
    return JSHTMLScriptElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLScriptElement, Base>(exec, propertyName, value, &JSHTMLScriptElementTable, this, slot);
}

void setJSHTMLScriptElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setText(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::forAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementEvent(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::eventAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::charsetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementAsync(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAsync(value.toBoolean(exec));
}


void setJSHTMLScriptElementDefer(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::deferAttr, value.toBoolean(exec));
}


void setJSHTMLScriptElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLScriptElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLScriptElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
