/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLLabelElement.h"

#include "HTMLElement.h"
#include "HTMLFormElement.h"
#include "HTMLLabelElement.h"
#include "HTMLNames.h"
#include "JSHTMLElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLLabelElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLabelElementTableValues[] =
{
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementForm), (intptr_t)0 THUNK_GENERATOR(0) },
    { "accessKey", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementAccessKey), (intptr_t)setJSHTMLLabelElementAccessKey THUNK_GENERATOR(0) },
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementHtmlFor), (intptr_t)setJSHTMLLabelElementHtmlFor THUNK_GENERATOR(0) },
    { "control", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementControl), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLabelElementTable = { 18, 15, JSHTMLLabelElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLabelElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLabelElementConstructorTable = { 1, 0, JSHTMLLabelElementConstructorTableValues, 0 };
class JSHTMLLabelElementConstructor : public DOMConstructorObject {
private:
    JSHTMLLabelElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLLabelElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLLabelElementConstructor* ptr = new (JSC::allocateCell<JSHTMLLabelElementConstructor>(*exec->heap())) JSHTMLLabelElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLLabelElementConstructor::s_info = { "HTMLLabelElementConstructor", &DOMConstructorObject::s_info, &JSHTMLLabelElementConstructorTable, 0 };

JSHTMLLabelElementConstructor::JSHTMLLabelElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLLabelElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLLabelElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLLabelElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElementConstructor, JSDOMWrapper>(exec, &JSHTMLLabelElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLLabelElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLLabelElementConstructor, JSDOMWrapper>(exec, &JSHTMLLabelElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLLabelElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLLabelElementPrototypeTable = { 1, 0, JSHTMLLabelElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLLabelElementPrototype::s_info = { "HTMLLabelElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLLabelElementPrototypeTable, 0 };

JSObject* JSHTMLLabelElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLLabelElement>(exec, globalObject);
}

const ClassInfo JSHTMLLabelElement::s_info = { "HTMLLabelElement", &JSHTMLElement::s_info, &JSHTMLLabelElementTable, 0 };

JSHTMLLabelElement::JSHTMLLabelElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLLabelElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLLabelElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLLabelElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLLabelElementPrototype::create(exec->globalData(), globalObject, JSHTMLLabelElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLLabelElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, this, propertyName, slot);
}

bool JSHTMLLabelElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLLabelElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}


JSValue jsHTMLLabelElementAccessKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::accesskeyAttr));
    return result;
}


JSValue jsHTMLLabelElementHtmlFor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::forAttr));
    return result;
}


JSValue jsHTMLLabelElementControl(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->control()));
    return result;
}


JSValue jsHTMLLabelElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLLabelElement* domObject = static_cast<JSHTMLLabelElement*>(asObject(slotBase));
    return JSHTMLLabelElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLLabelElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLLabelElement, Base>(exec, propertyName, value, &JSHTMLLabelElementTable, this, slot);
}

void setJSHTMLLabelElementAccessKey(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(thisObject);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::accesskeyAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLLabelElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLLabelElement* castedThis = static_cast<JSHTMLLabelElement*>(thisObject);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::forAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLLabelElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLLabelElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
