/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLInputElement.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "FileList.h"
#include "HTMLFormElement.h"
#include "HTMLInputElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSFileList.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(DATALIST)
#include "HTMLElement.h"
#include "HTMLOptionElement.h"
#include "JSHTMLElement.h"
#include "JSHTMLOptionElement.h"
#endif

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLInputElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLInputElementTableValues[] =
{
    { "defaultValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDefaultValue), (intptr_t)setJSHTMLInputElementDefaultValue THUNK_GENERATOR(0) },
    { "defaultChecked", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDefaultChecked), (intptr_t)setJSHTMLInputElementDefaultChecked THUNK_GENERATOR(0) },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementForm), (intptr_t)0 THUNK_GENERATOR(0) },
    { "formAction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormAction), (intptr_t)setJSHTMLInputElementFormAction THUNK_GENERATOR(0) },
    { "formEnctype", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormEnctype), (intptr_t)setJSHTMLInputElementFormEnctype THUNK_GENERATOR(0) },
    { "formMethod", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormMethod), (intptr_t)setJSHTMLInputElementFormMethod THUNK_GENERATOR(0) },
    { "formNoValidate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormNoValidate), (intptr_t)setJSHTMLInputElementFormNoValidate THUNK_GENERATOR(0) },
    { "formTarget", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormTarget), (intptr_t)setJSHTMLInputElementFormTarget THUNK_GENERATOR(0) },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "accept", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAccept), (intptr_t)setJSHTMLInputElementAccept THUNK_GENERATOR(0) },
    { "accessKey", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAccessKey), (intptr_t)setJSHTMLInputElementAccessKey THUNK_GENERATOR(0) },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAlign), (intptr_t)setJSHTMLInputElementAlign THUNK_GENERATOR(0) },
    { "alt", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAlt), (intptr_t)setJSHTMLInputElementAlt THUNK_GENERATOR(0) },
    { "checked", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementChecked), (intptr_t)setJSHTMLInputElementChecked THUNK_GENERATOR(0) },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDisabled), (intptr_t)setJSHTMLInputElementDisabled THUNK_GENERATOR(0) },
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAutofocus), (intptr_t)setJSHTMLInputElementAutofocus THUNK_GENERATOR(0) },
    { "autocomplete", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAutocomplete), (intptr_t)setJSHTMLInputElementAutocomplete THUNK_GENERATOR(0) },
#if ENABLE(DATALIST)
    { "list", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementList), (intptr_t)0 THUNK_GENERATOR(0) },
#endif
    { "max", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMax), (intptr_t)setJSHTMLInputElementMax THUNK_GENERATOR(0) },
    { "maxLength", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMaxLength), (intptr_t)setJSHTMLInputElementMaxLength THUNK_GENERATOR(0) },
    { "min", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMin), (intptr_t)setJSHTMLInputElementMin THUNK_GENERATOR(0) },
    { "multiple", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMultiple), (intptr_t)setJSHTMLInputElementMultiple THUNK_GENERATOR(0) },
#if ENABLE(DIRECTORY_UPLOAD)
    { "webkitdirectory", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitdirectory), (intptr_t)setJSHTMLInputElementWebkitdirectory THUNK_GENERATOR(0) },
#endif
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementName), (intptr_t)setJSHTMLInputElementName THUNK_GENERATOR(0) },
    { "pattern", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementPattern), (intptr_t)setJSHTMLInputElementPattern THUNK_GENERATOR(0) },
    { "placeholder", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementPlaceholder), (intptr_t)setJSHTMLInputElementPlaceholder THUNK_GENERATOR(0) },
    { "readOnly", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementReadOnly), (intptr_t)setJSHTMLInputElementReadOnly THUNK_GENERATOR(0) },
    { "required", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementRequired), (intptr_t)setJSHTMLInputElementRequired THUNK_GENERATOR(0) },
    { "size", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSize), (intptr_t)setJSHTMLInputElementSize THUNK_GENERATOR(0) },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSrc), (intptr_t)setJSHTMLInputElementSrc THUNK_GENERATOR(0) },
    { "step", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementStep), (intptr_t)setJSHTMLInputElementStep THUNK_GENERATOR(0) },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementType), (intptr_t)setJSHTMLInputElementType THUNK_GENERATOR(0) },
    { "useMap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementUseMap), (intptr_t)setJSHTMLInputElementUseMap THUNK_GENERATOR(0) },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValue), (intptr_t)setJSHTMLInputElementValue THUNK_GENERATOR(0) },
    { "valueAsDate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValueAsDate), (intptr_t)setJSHTMLInputElementValueAsDate THUNK_GENERATOR(0) },
    { "valueAsNumber", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValueAsNumber), (intptr_t)setJSHTMLInputElementValueAsNumber THUNK_GENERATOR(0) },
#if ENABLE(DATALIST)
    { "selectedOption", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectedOption), (intptr_t)0 THUNK_GENERATOR(0) },
#endif
    { "incremental", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementIncremental), (intptr_t)setJSHTMLInputElementIncremental THUNK_GENERATOR(0) },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWillValidate), (intptr_t)0 THUNK_GENERATOR(0) },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValidationMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "indeterminate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementIndeterminate), (intptr_t)setJSHTMLInputElementIndeterminate THUNK_GENERATOR(0) },
    { "selectionStart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionStart), (intptr_t)setJSHTMLInputElementSelectionStart THUNK_GENERATOR(0) },
    { "selectionEnd", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionEnd), (intptr_t)setJSHTMLInputElementSelectionEnd THUNK_GENERATOR(0) },
    { "selectionDirection", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionDirection), (intptr_t)setJSHTMLInputElementSelectionDirection THUNK_GENERATOR(0) },
    { "files", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFiles), (intptr_t)0 THUNK_GENERATOR(0) },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementLabels), (intptr_t)0 THUNK_GENERATOR(0) },
#if ENABLE(INPUT_SPEECH)
    { "webkitSpeech", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitSpeech), (intptr_t)setJSHTMLInputElementWebkitSpeech THUNK_GENERATOR(0) },
#endif
#if ENABLE(INPUT_SPEECH)
    { "webkitGrammar", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitGrammar), (intptr_t)setJSHTMLInputElementWebkitGrammar THUNK_GENERATOR(0) },
#endif
#if ENABLE(INPUT_SPEECH)
    { "onwebkitspeechchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementOnwebkitspeechchange), (intptr_t)setJSHTMLInputElementOnwebkitspeechchange THUNK_GENERATOR(0) },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLInputElementTable = { 135, 127, JSHTMLInputElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLInputElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLInputElementConstructorTable = { 1, 0, JSHTMLInputElementConstructorTableValues, 0 };
class JSHTMLInputElementConstructor : public DOMConstructorObject {
private:
    JSHTMLInputElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLInputElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLInputElementConstructor* ptr = new (JSC::allocateCell<JSHTMLInputElementConstructor>(*exec->heap())) JSHTMLInputElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLInputElementConstructor::s_info = { "HTMLInputElementConstructor", &DOMConstructorObject::s_info, &JSHTMLInputElementConstructorTable, 0 };

JSHTMLInputElementConstructor::JSHTMLInputElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLInputElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLInputElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLInputElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLInputElementConstructor, JSDOMWrapper>(exec, &JSHTMLInputElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLInputElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLInputElementConstructor, JSDOMWrapper>(exec, &JSHTMLInputElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLInputElementPrototypeTableValues[] =
{
    { "stepUp", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionStepUp), (intptr_t)1 THUNK_GENERATOR(0) },
    { "stepDown", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionStepDown), (intptr_t)1 THUNK_GENERATOR(0) },
    { "checkValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionCheckValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setCustomValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSetCustomValidity), (intptr_t)1 THUNK_GENERATOR(0) },
    { "select", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSelect), (intptr_t)0 THUNK_GENERATOR(0) },
    { "click", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionClick), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setSelectionRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSetSelectionRange), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLInputElementPrototypeTable = { 17, 15, JSHTMLInputElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLInputElementPrototype::s_info = { "HTMLInputElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLInputElementPrototypeTable, 0 };

JSObject* JSHTMLInputElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLInputElement>(exec, globalObject);
}

bool JSHTMLInputElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLInputElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLInputElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLInputElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLInputElement::s_info = { "HTMLInputElement", &JSHTMLElement::s_info, &JSHTMLInputElementTable, 0 };

JSHTMLInputElement::JSHTMLInputElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLInputElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLInputElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLInputElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLInputElementPrototype::create(exec->globalData(), globalObject, JSHTMLInputElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLInputElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLInputElement, Base>(exec, &JSHTMLInputElementTable, this, propertyName, slot);
}

bool JSHTMLInputElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLInputElement, Base>(exec, &JSHTMLInputElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLInputElementDefaultValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->defaultValue());
    return result;
}


JSValue jsHTMLInputElementDefaultChecked(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::checkedAttr));
    return result;
}


JSValue jsHTMLInputElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}


JSValue jsHTMLInputElementFormAction(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::formactionAttr));
    return result;
}


JSValue jsHTMLInputElementFormEnctype(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::formenctypeAttr));
    return result;
}


JSValue jsHTMLInputElementFormMethod(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::formmethodAttr));
    return result;
}


JSValue jsHTMLInputElementFormNoValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::formnovalidateAttr));
    return result;
}


JSValue jsHTMLInputElementFormTarget(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::formtargetAttr));
    return result;
}


JSValue jsHTMLInputElementValidity(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->validity()));
    return result;
}


JSValue jsHTMLInputElementAccept(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::acceptAttr));
    return result;
}


JSValue jsHTMLInputElementAccessKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::accesskeyAttr));
    return result;
}


JSValue jsHTMLInputElementAlign(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLInputElementAlt(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::altAttr));
    return result;
}


JSValue jsHTMLInputElementChecked(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->checked());
    return result;
}


JSValue jsHTMLInputElementDisabled(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLInputElementAutofocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLInputElementAutocomplete(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::autocompleteAttr));
    return result;
}


#if ENABLE(DATALIST)
JSValue jsHTMLInputElementList(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->list()));
    return result;
}

#endif

JSValue jsHTMLInputElementMax(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::maxAttr));
    return result;
}


JSValue jsHTMLInputElementMaxLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->maxLength());
    return result;
}


JSValue jsHTMLInputElementMin(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::minAttr));
    return result;
}


JSValue jsHTMLInputElementMultiple(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::multipleAttr));
    return result;
}


#if ENABLE(DIRECTORY_UPLOAD)
JSValue jsHTMLInputElementWebkitdirectory(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::webkitdirectoryAttr));
    return result;
}

#endif

JSValue jsHTMLInputElementName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLInputElementPattern(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::patternAttr));
    return result;
}


JSValue jsHTMLInputElementPlaceholder(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::placeholderAttr));
    return result;
}


JSValue jsHTMLInputElementReadOnly(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::readonlyAttr));
    return result;
}


JSValue jsHTMLInputElementRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::requiredAttr));
    return result;
}


JSValue jsHTMLInputElementSize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->size());
    return result;
}


JSValue jsHTMLInputElementSrc(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLInputElementStep(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::stepAttr));
    return result;
}


JSValue jsHTMLInputElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}


JSValue jsHTMLInputElementUseMap(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}


JSValue jsHTMLInputElementValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->value());
    return result;
}


JSValue jsHTMLInputElementValueAsDate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsDateOrNull(exec, imp->valueAsDate());
    return result;
}


JSValue jsHTMLInputElementValueAsNumber(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->valueAsNumber());
    return result;
}


#if ENABLE(DATALIST)
JSValue jsHTMLInputElementSelectedOption(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->selectedOption()));
    return result;
}

#endif

JSValue jsHTMLInputElementIncremental(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::incrementalAttr));
    return result;
}


JSValue jsHTMLInputElementWillValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->willValidate());
    return result;
}


JSValue jsHTMLInputElementValidationMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->validationMessage());
    return result;
}


JSValue jsHTMLInputElementIndeterminate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->indeterminate());
    return result;
}


JSValue jsHTMLInputElementSelectionStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionStart(exec);
}


JSValue jsHTMLInputElementSelectionEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionEnd(exec);
}


JSValue jsHTMLInputElementSelectionDirection(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionDirection(exec);
}


JSValue jsHTMLInputElementFiles(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->files()));
    return result;
}


JSValue jsHTMLInputElementLabels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->labels()));
    return result;
}


#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementWebkitSpeech(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::webkitspeechAttr));
    return result;
}

#endif

#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementWebkitGrammar(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::webkitgrammarAttr));
    return result;
}

#endif

#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementOnwebkitspeechchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    if (EventListener* listener = imp->onwebkitspeechchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

JSValue jsHTMLInputElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLInputElement* domObject = static_cast<JSHTMLInputElement*>(asObject(slotBase));
    return JSHTMLInputElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLInputElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLInputElement, Base>(exec, propertyName, value, &JSHTMLInputElementTable, this, slot);
}

void setJSHTMLInputElementDefaultValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setDefaultValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementDefaultChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::checkedAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementFormAction(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::formactionAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormEnctype(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::formenctypeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormMethod(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::formmethodAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormNoValidate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementFormTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::formtargetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAccept(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::acceptAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAccessKey(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::accesskeyAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAlt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::altAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setChecked(value.toBoolean(exec));
}


void setJSHTMLInputElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementAutocomplete(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::autocompleteAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementMax(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::maxAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementMaxLength(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setMaxLength(value.toInt32(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementMin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::minAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementMultiple(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::multipleAttr, value.toBoolean(exec));
}


#if ENABLE(DIRECTORY_UPLOAD)
void setJSHTMLInputElementWebkitdirectory(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::webkitdirectoryAttr, value.toBoolean(exec));
}

#endif

void setJSHTMLInputElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementPattern(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::patternAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementPlaceholder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::placeholderAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementReadOnly(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementRequired(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setSize(value.toUInt32(exec));
}


void setJSHTMLInputElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementStep(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::stepAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementUseMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::usemapAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementValueAsDate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setValueAsDate(valueToDate(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementValueAsNumber(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setValueAsNumber(value.toNumber(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementIncremental(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::incrementalAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementIndeterminate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setIndeterminate(value.toBoolean(exec));
}


void setJSHTMLInputElementSelectionStart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLInputElement*>(thisObject)->setSelectionStart(exec, value);
}


void setJSHTMLInputElementSelectionEnd(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLInputElement*>(thisObject)->setSelectionEnd(exec, value);
}


void setJSHTMLInputElementSelectionDirection(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLInputElement*>(thisObject)->setSelectionDirection(exec, value);
}


#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementWebkitSpeech(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::webkitspeechAttr, value.toBoolean(exec));
}

#endif

#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementWebkitGrammar(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::webkitgrammarAttr, value.toBoolean(exec));
}

#endif

#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementOnwebkitspeechchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    imp->setOnwebkitspeechchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

JSValue JSHTMLInputElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLInputElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepUp(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        imp->stepUp(ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int n(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->stepUp(n, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepDown(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        imp->stepDown(ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int n(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->stepDown(n, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());


    JSC::JSValue result = jsBoolean(imp->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSelect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());

    imp->select();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionClick(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThis->impl());

    imp->click();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetSelectionRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = static_cast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    return JSValue::encode(castedThis->setSelectionRange(exec));
}


}
