/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB)

#include "JSFileReaderSync.h"

#include "ArrayBuffer.h"
#include "ExceptionCode.h"
#include "FileReaderSync.h"
#include "JSArrayBuffer.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFileReaderSync);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderSyncTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderSyncConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderSyncTable = { 2, 1, JSFileReaderSyncTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderSyncConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderSyncConstructorTable = { 1, 0, JSFileReaderSyncConstructorTableValues, 0 };
class JSFileReaderSyncConstructor : public DOMConstructorObject {
private:
    JSFileReaderSyncConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSFileReaderSyncConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSFileReaderSyncConstructor* ptr = new (JSC::allocateCell<JSFileReaderSyncConstructor>(*exec->heap())) JSFileReaderSyncConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSFileReaderSync(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

const ClassInfo JSFileReaderSyncConstructor::s_info = { "FileReaderSyncConstructor", &DOMConstructorObject::s_info, &JSFileReaderSyncConstructorTable, 0 };

JSFileReaderSyncConstructor::JSFileReaderSyncConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFileReaderSyncConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFileReaderSyncPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFileReaderSyncConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileReaderSyncConstructor, JSDOMWrapper>(exec, &JSFileReaderSyncConstructorTable, this, propertyName, slot);
}

bool JSFileReaderSyncConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileReaderSyncConstructor, JSDOMWrapper>(exec, &JSFileReaderSyncConstructorTable, this, propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSFileReaderSyncConstructor::constructJSFileReaderSync(ExecState* exec)
{
    return JSValue::encode(asObject(toJS(exec, static_cast<JSFileReaderSyncConstructor*>(exec->callee())->globalObject(), FileReaderSync::create())));
}

ConstructType JSFileReaderSyncConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSFileReaderSync;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderSyncPrototypeTableValues[] =
{
    { "readAsArrayBuffer", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsArrayBuffer), (intptr_t)1 THUNK_GENERATOR(0) },
    { "readAsBinaryString", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsBinaryString), (intptr_t)1 THUNK_GENERATOR(0) },
    { "readAsText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsText), (intptr_t)2 THUNK_GENERATOR(0) },
    { "readAsDataURL", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsDataURL), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderSyncPrototypeTable = { 9, 7, JSFileReaderSyncPrototypeTableValues, 0 };
static const HashTable* getJSFileReaderSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileReaderSyncPrototypeTable);
}

const ClassInfo JSFileReaderSyncPrototype::s_info = { "FileReaderSyncPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSFileReaderSyncPrototypeTable };

JSObject* JSFileReaderSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileReaderSync>(exec, globalObject);
}

bool JSFileReaderSyncPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSFileReaderSyncPrototypeTable(exec), this, propertyName, slot);
}

bool JSFileReaderSyncPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSFileReaderSyncPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSFileReaderSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileReaderSyncTable);
}

const ClassInfo JSFileReaderSync::s_info = { "FileReaderSync", &JSDOMWrapper::s_info, 0, getJSFileReaderSyncTable };

JSFileReaderSync::JSFileReaderSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileReaderSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSFileReaderSync::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileReaderSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileReaderSyncPrototype::create(exec->globalData(), globalObject, JSFileReaderSyncPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSFileReaderSync::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSFileReaderSync, Base>(exec, getJSFileReaderSyncTable(exec), this, propertyName, slot);
}

bool JSFileReaderSync::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSFileReaderSync, Base>(exec, getJSFileReaderSyncTable(exec), this, propertyName, descriptor);
}

JSValue jsFileReaderSyncConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReaderSync* domObject = static_cast<JSFileReaderSync*>(asObject(slotBase));
    return JSFileReaderSync::getConstructor(exec, domObject->globalObject());
}

JSValue JSFileReaderSync::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileReaderSyncConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsArrayBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReaderSync::s_info))
        return throwVMTypeError(exec);
    JSFileReaderSync* castedThis = static_cast<JSFileReaderSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReaderSync::s_info);
    FileReaderSync* imp = static_cast<FileReaderSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->readAsArrayBuffer(scriptContext, blob, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsBinaryString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReaderSync::s_info))
        return throwVMTypeError(exec);
    JSFileReaderSync* castedThis = static_cast<JSFileReaderSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReaderSync::s_info);
    FileReaderSync* imp = static_cast<FileReaderSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsOwnedStringOrNull(exec, imp->readAsBinaryString(scriptContext, blob, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReaderSync::s_info))
        return throwVMTypeError(exec);
    JSFileReaderSync* castedThis = static_cast<JSFileReaderSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReaderSync::s_info);
    FileReaderSync* imp = static_cast<FileReaderSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsOwnedStringOrNull(exec, imp->readAsText(scriptContext, blob, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    const String& encoding(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsOwnedStringOrNull(exec, imp->readAsText(scriptContext, blob, encoding, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsDataURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReaderSync::s_info))
        return throwVMTypeError(exec);
    JSFileReaderSync* castedThis = static_cast<JSFileReaderSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReaderSync::s_info);
    FileReaderSync* imp = static_cast<FileReaderSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsOwnedStringOrNull(exec, imp->readAsDataURL(scriptContext, blob, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileReaderSync* impl)
{
    return wrap<JSFileReaderSync>(exec, globalObject, impl);
}

FileReaderSync* toFileReaderSync(JSC::JSValue value)
{
    return value.inherits(&JSFileReaderSync::s_info) ? static_cast<JSFileReaderSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB)
