/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSFileEntrySync.h"

#include "ExceptionCode.h"
#include "File.h"
#include "FileEntrySync.h"
#include "FileWriterSync.h"
#include "JSDOMBinding.h"
#include "JSFile.h"
#include "JSFileWriterSync.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFileEntrySync);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileEntrySyncTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileEntrySyncConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileEntrySyncTable = { 2, 1, JSFileEntrySyncTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileEntrySyncConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileEntrySyncConstructorTable = { 1, 0, JSFileEntrySyncConstructorTableValues, 0 };
class JSFileEntrySyncConstructor : public DOMConstructorObject {
private:
    JSFileEntrySyncConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSFileEntrySyncConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSFileEntrySyncConstructor* ptr = new (JSC::allocateCell<JSFileEntrySyncConstructor>(*exec->heap())) JSFileEntrySyncConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSFileEntrySyncConstructor::s_info = { "FileEntrySyncConstructor", &DOMConstructorObject::s_info, &JSFileEntrySyncConstructorTable, 0 };

JSFileEntrySyncConstructor::JSFileEntrySyncConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFileEntrySyncConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFileEntrySyncPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFileEntrySyncConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileEntrySyncConstructor, JSDOMWrapper>(exec, &JSFileEntrySyncConstructorTable, this, propertyName, slot);
}

bool JSFileEntrySyncConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileEntrySyncConstructor, JSDOMWrapper>(exec, &JSFileEntrySyncConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileEntrySyncPrototypeTableValues[] =
{
    { "file", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileEntrySyncPrototypeFunctionFile), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createWriter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileEntrySyncPrototypeFunctionCreateWriter), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileEntrySyncPrototypeTable = { 5, 3, JSFileEntrySyncPrototypeTableValues, 0 };
static const HashTable* getJSFileEntrySyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileEntrySyncPrototypeTable);
}

const ClassInfo JSFileEntrySyncPrototype::s_info = { "FileEntrySyncPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSFileEntrySyncPrototypeTable };

JSObject* JSFileEntrySyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileEntrySync>(exec, globalObject);
}

bool JSFileEntrySyncPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSFileEntrySyncPrototypeTable(exec), this, propertyName, slot);
}

bool JSFileEntrySyncPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSFileEntrySyncPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSFileEntrySyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileEntrySyncTable);
}

const ClassInfo JSFileEntrySync::s_info = { "FileEntrySync", &JSEntrySync::s_info, 0, getJSFileEntrySyncTable };

JSFileEntrySync::JSFileEntrySync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileEntrySync> impl)
    : JSEntrySync(structure, globalObject, impl)
{
}

void JSFileEntrySync::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileEntrySync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileEntrySyncPrototype::create(exec->globalData(), globalObject, JSFileEntrySyncPrototype::createStructure(exec->globalData(), globalObject, JSEntrySyncPrototype::self(exec, globalObject)));
}

bool JSFileEntrySync::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSFileEntrySync, Base>(exec, getJSFileEntrySyncTable(exec), this, propertyName, slot);
}

bool JSFileEntrySync::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSFileEntrySync, Base>(exec, getJSFileEntrySyncTable(exec), this, propertyName, descriptor);
}

JSValue jsFileEntrySyncConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileEntrySync* domObject = static_cast<JSFileEntrySync*>(asObject(slotBase));
    return JSFileEntrySync::getConstructor(exec, domObject->globalObject());
}

JSValue JSFileEntrySync::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileEntrySyncConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileEntrySyncPrototypeFunctionFile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileEntrySync::s_info))
        return throwVMTypeError(exec);
    JSFileEntrySync* castedThis = static_cast<JSFileEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileEntrySync::s_info);
    FileEntrySync* imp = static_cast<FileEntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->file(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileEntrySyncPrototypeFunctionCreateWriter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileEntrySync::s_info))
        return throwVMTypeError(exec);
    JSFileEntrySync* castedThis = static_cast<JSFileEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileEntrySync::s_info);
    FileEntrySync* imp = static_cast<FileEntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createWriter(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileEntrySync* impl)
{
    return wrap<JSFileEntrySync>(exec, globalObject, impl);
}

FileEntrySync* toFileEntrySync(JSC::JSValue value)
{
    return value.inherits(&JSFileEntrySync::s_info) ? static_cast<JSFileEntrySync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
