/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSEntry.h"

#include "DOMFileSystem.h"
#include "Entry.h"
#include "ExceptionCode.h"
#include "JSCustomVoidCallback.h"
#include "JSDOMBinding.h"
#include "JSDOMFileSystem.h"
#include "JSDirectoryEntry.h"
#include "JSEntryCallback.h"
#include "JSErrorCallback.h"
#include "JSMetadataCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEntry);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntryTableValues[] =
{
    { "isFile", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryIsFile), (intptr_t)0 THUNK_GENERATOR(0) },
    { "isDirectory", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryIsDirectory), (intptr_t)0 THUNK_GENERATOR(0) },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "fullPath", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryFullPath), (intptr_t)0 THUNK_GENERATOR(0) },
    { "filesystem", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryFilesystem), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntryTable = { 17, 15, JSEntryTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntryConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntryConstructorTable = { 1, 0, JSEntryConstructorTableValues, 0 };
class JSEntryConstructor : public DOMConstructorObject {
private:
    JSEntryConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSEntryConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSEntryConstructor* ptr = new (JSC::allocateCell<JSEntryConstructor>(*exec->heap())) JSEntryConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSEntryConstructor::s_info = { "EntryConstructor", &DOMConstructorObject::s_info, &JSEntryConstructorTable, 0 };

JSEntryConstructor::JSEntryConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSEntryConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSEntryPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSEntryConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntryConstructor, JSDOMWrapper>(exec, &JSEntryConstructorTable, this, propertyName, slot);
}

bool JSEntryConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntryConstructor, JSDOMWrapper>(exec, &JSEntryConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntryPrototypeTableValues[] =
{
    { "getMetadata", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionGetMetadata), (intptr_t)2 THUNK_GENERATOR(0) },
    { "moveTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionMoveTo), (intptr_t)4 THUNK_GENERATOR(0) },
    { "copyTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionCopyTo), (intptr_t)4 THUNK_GENERATOR(0) },
    { "toURL", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionToURL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "remove", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionRemove), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getParent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsEntryPrototypeFunctionGetParent), (intptr_t)2 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntryPrototypeTable = { 17, 15, JSEntryPrototypeTableValues, 0 };
static const HashTable* getJSEntryPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSEntryPrototypeTable);
}

const ClassInfo JSEntryPrototype::s_info = { "EntryPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSEntryPrototypeTable };

JSObject* JSEntryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntry>(exec, globalObject);
}

bool JSEntryPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSEntryPrototypeTable(exec), this, propertyName, slot);
}

bool JSEntryPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSEntryPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSEntryTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSEntryTable);
}

const ClassInfo JSEntry::s_info = { "Entry", &JSDOMWrapper::s_info, 0, getJSEntryTable };

JSEntry::JSEntry(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Entry> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSEntry::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntry::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntryPrototype::create(exec->globalData(), globalObject, JSEntryPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSEntry::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSEntry, Base>(exec, getJSEntryTable(exec), this, propertyName, slot);
}

bool JSEntry::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSEntry, Base>(exec, getJSEntryTable(exec), this, propertyName, descriptor);
}

JSValue jsEntryIsFile(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isFile());
    return result;
}


JSValue jsEntryIsDirectory(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isDirectory());
    return result;
}


JSValue jsEntryName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsEntryFullPath(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    JSValue result = jsString(exec, imp->fullPath());
    return result;
}


JSValue jsEntryFilesystem(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->filesystem()));
    return result;
}


JSValue jsEntryConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntry* domObject = static_cast<JSEntry*>(asObject(slotBase));
    return JSEntry::getConstructor(exec, domObject->globalObject());
}

JSValue JSEntry::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEntryConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionGetMetadata(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    RefPtr<MetadataCallback> successCallback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSMetadataCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }

    imp->getMetadata(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionMoveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    DirectoryEntry* parent(toDirectoryEntry(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        imp->moveTo(parent);
        return JSValue::encode(jsUndefined());
    }

    const String& name(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<EntryCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSEntryCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }

    imp->moveTo(parent, name, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionCopyTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    DirectoryEntry* parent(toDirectoryEntry(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        imp->copyTo(parent);
        return JSValue::encode(jsUndefined());
    }

    const String& name(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<EntryCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSEntryCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }

    imp->copyTo(parent, name, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionToURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toURL());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    RefPtr<VoidCallback> successCallback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSCustomVoidCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }

    imp->remove(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEntryPrototypeFunctionGetParent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntry::s_info))
        return throwVMTypeError(exec);
    JSEntry* castedThis = static_cast<JSEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntry::s_info);
    Entry* imp = static_cast<Entry*>(castedThis->impl());
    RefPtr<EntryCallback> successCallback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSEntryCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }

    imp->getParent(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

Entry* toEntry(JSC::JSValue value)
{
    return value.inherits(&JSEntry::s_info) ? static_cast<JSEntry*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
