/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDirectoryEntry.h"

#include "DirectoryEntry.h"
#include "DirectoryReader.h"
#include "ExceptionCode.h"
#include "JSCustomVoidCallback.h"
#include "JSDOMBinding.h"
#include "JSDirectoryReader.h"
#include "JSErrorCallback.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDirectoryEntry);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryEntryTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDirectoryEntryConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryEntryTable = { 2, 1, JSDirectoryEntryTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryEntryConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryEntryConstructorTable = { 1, 0, JSDirectoryEntryConstructorTableValues, 0 };
class JSDirectoryEntryConstructor : public DOMConstructorObject {
private:
    JSDirectoryEntryConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDirectoryEntryConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDirectoryEntryConstructor* ptr = new (JSC::allocateCell<JSDirectoryEntryConstructor>(*exec->heap())) JSDirectoryEntryConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDirectoryEntryConstructor::s_info = { "DirectoryEntryConstructor", &DOMConstructorObject::s_info, &JSDirectoryEntryConstructorTable, 0 };

JSDirectoryEntryConstructor::JSDirectoryEntryConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDirectoryEntryConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDirectoryEntryPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDirectoryEntryConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDirectoryEntryConstructor, JSDOMWrapper>(exec, &JSDirectoryEntryConstructorTable, this, propertyName, slot);
}

bool JSDirectoryEntryConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDirectoryEntryConstructor, JSDOMWrapper>(exec, &JSDirectoryEntryConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryEntryPrototypeTableValues[] =
{
    { "createReader", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionCreateReader), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getFile", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionGetFile), (intptr_t)4 THUNK_GENERATOR(0) },
    { "getDirectory", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionGetDirectory), (intptr_t)4 THUNK_GENERATOR(0) },
    { "removeRecursively", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionRemoveRecursively), (intptr_t)2 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryEntryPrototypeTable = { 10, 7, JSDirectoryEntryPrototypeTableValues, 0 };
static const HashTable* getJSDirectoryEntryPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDirectoryEntryPrototypeTable);
}

const ClassInfo JSDirectoryEntryPrototype::s_info = { "DirectoryEntryPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSDirectoryEntryPrototypeTable };

JSObject* JSDirectoryEntryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDirectoryEntry>(exec, globalObject);
}

bool JSDirectoryEntryPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDirectoryEntryPrototypeTable(exec), this, propertyName, slot);
}

bool JSDirectoryEntryPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDirectoryEntryPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSDirectoryEntryTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDirectoryEntryTable);
}

const ClassInfo JSDirectoryEntry::s_info = { "DirectoryEntry", &JSEntry::s_info, 0, getJSDirectoryEntryTable };

JSDirectoryEntry::JSDirectoryEntry(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DirectoryEntry> impl)
    : JSEntry(structure, globalObject, impl)
{
}

void JSDirectoryEntry::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDirectoryEntry::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDirectoryEntryPrototype::create(exec->globalData(), globalObject, JSDirectoryEntryPrototype::createStructure(exec->globalData(), globalObject, JSEntryPrototype::self(exec, globalObject)));
}

bool JSDirectoryEntry::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSDirectoryEntry, Base>(exec, getJSDirectoryEntryTable(exec), this, propertyName, slot);
}

bool JSDirectoryEntry::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSDirectoryEntry, Base>(exec, getJSDirectoryEntryTable(exec), this, propertyName, descriptor);
}

JSValue jsDirectoryEntryConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDirectoryEntry* domObject = static_cast<JSDirectoryEntry*>(asObject(slotBase));
    return JSDirectoryEntry::getConstructor(exec, domObject->globalObject());
}

JSValue JSDirectoryEntry::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDirectoryEntryConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionCreateReader(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = static_cast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* imp = static_cast<DirectoryEntry*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createReader()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetFile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = static_cast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    return JSValue::encode(castedThis->getFile(exec));
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetDirectory(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = static_cast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    return JSValue::encode(castedThis->getDirectory(exec));
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionRemoveRecursively(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = static_cast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* imp = static_cast<DirectoryEntry*>(castedThis->impl());
    RefPtr<VoidCallback> successCallback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        successCallback = JSCustomVoidCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }

    imp->removeRecursively(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DirectoryEntry* impl)
{
    return wrap<JSDirectoryEntry>(exec, globalObject, impl);
}

DirectoryEntry* toDirectoryEntry(JSC::JSValue value)
{
    return value.inherits(&JSDirectoryEntry::s_info) ? static_cast<JSDirectoryEntry*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
