/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATABASE)

#include "JSDatabaseSync.h"

#include "DatabaseSync.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSQLTransactionSyncCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDatabaseSync);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDatabaseSyncTableValues[] =
{
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDatabaseSyncVersion), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDatabaseSyncTable = { 2, 1, JSDatabaseSyncTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDatabaseSyncPrototypeTableValues[] =
{
    { "changeVersion", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionChangeVersion), (intptr_t)3 THUNK_GENERATOR(0) },
    { "transaction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionTransaction), (intptr_t)1 THUNK_GENERATOR(0) },
    { "readTransaction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionReadTransaction), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDatabaseSyncPrototypeTable = { 8, 7, JSDatabaseSyncPrototypeTableValues, 0 };
static const HashTable* getJSDatabaseSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDatabaseSyncPrototypeTable);
}

const ClassInfo JSDatabaseSyncPrototype::s_info = { "DatabaseSyncPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSDatabaseSyncPrototypeTable };

JSObject* JSDatabaseSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDatabaseSync>(exec, globalObject);
}

bool JSDatabaseSyncPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), this, propertyName, slot);
}

bool JSDatabaseSyncPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSDatabaseSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDatabaseSyncTable);
}

const ClassInfo JSDatabaseSync::s_info = { "DatabaseSync", &JSDOMWrapper::s_info, 0, getJSDatabaseSyncTable };

JSDatabaseSync::JSDatabaseSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DatabaseSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSDatabaseSync::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDatabaseSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDatabaseSyncPrototype::create(exec->globalData(), globalObject, JSDatabaseSyncPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSDatabaseSync::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), this, propertyName, slot);
}

bool JSDatabaseSync::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), this, propertyName, descriptor);
}

JSValue jsDatabaseSyncVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DatabaseSync* imp = static_cast<DatabaseSync*>(castedThis->impl());
    JSValue result = jsString(exec, imp->version());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionChangeVersion(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* imp = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& oldVersion(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newVersion(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<SQLTransactionSyncCallback> callback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }

    imp->changeVersion(oldVersion, newVersion, callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* imp = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    if (exec->argumentCount() <= 0 || !exec->argument(0).isObject()) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    RefPtr<SQLTransactionSyncCallback> callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(0)), castedThis->globalObject());

    imp->transaction(callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionReadTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* imp = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    if (exec->argumentCount() <= 0 || !exec->argument(0).isObject()) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    RefPtr<SQLTransactionSyncCallback> callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(0)), castedThis->globalObject());

    imp->readTransaction(callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DatabaseSync* impl)
{
    return wrap<JSDatabaseSync>(exec, globalObject, impl);
}

DatabaseSync* toDatabaseSync(JSC::JSValue value)
{
    return value.inherits(&JSDatabaseSync::s_info) ? static_cast<JSDatabaseSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATABASE)
