/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATA_TRANSFER_ITEMS)

#include "JSDataTransferItems.h"

#include "DataTransferItem.h"
#include "DataTransferItems.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDataTransferItem.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDataTransferItems);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataTransferItemsTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItemsLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItemsConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataTransferItemsTable = { 5, 3, JSDataTransferItemsTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataTransferItemsConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataTransferItemsConstructorTable = { 1, 0, JSDataTransferItemsConstructorTableValues, 0 };
class JSDataTransferItemsConstructor : public DOMConstructorObject {
private:
    JSDataTransferItemsConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDataTransferItemsConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDataTransferItemsConstructor* ptr = new (JSC::allocateCell<JSDataTransferItemsConstructor>(*exec->heap())) JSDataTransferItemsConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDataTransferItemsConstructor::s_info = { "DataTransferItemsConstructor", &DOMConstructorObject::s_info, &JSDataTransferItemsConstructorTable, 0 };

JSDataTransferItemsConstructor::JSDataTransferItemsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDataTransferItemsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDataTransferItemsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDataTransferItemsConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDataTransferItemsConstructor, JSDOMWrapper>(exec, &JSDataTransferItemsConstructorTable, this, propertyName, slot);
}

bool JSDataTransferItemsConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDataTransferItemsConstructor, JSDOMWrapper>(exec, &JSDataTransferItemsConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataTransferItemsPrototypeTableValues[] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataTransferItemsPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "clear", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataTransferItemsPrototypeFunctionClear), (intptr_t)0 THUNK_GENERATOR(0) },
    { "add", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataTransferItemsPrototypeFunctionAdd), (intptr_t)2 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataTransferItemsPrototypeTable = { 9, 7, JSDataTransferItemsPrototypeTableValues, 0 };
const ClassInfo JSDataTransferItemsPrototype::s_info = { "DataTransferItemsPrototype", &JSC::JSNonFinalObject::s_info, &JSDataTransferItemsPrototypeTable, 0 };

JSObject* JSDataTransferItemsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataTransferItems>(exec, globalObject);
}

bool JSDataTransferItemsPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDataTransferItemsPrototypeTable, this, propertyName, slot);
}

bool JSDataTransferItemsPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDataTransferItemsPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDataTransferItems::s_info = { "DataTransferItems", &JSDOMWrapper::s_info, &JSDataTransferItemsTable, 0 };

JSDataTransferItems::JSDataTransferItems(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DataTransferItems> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSDataTransferItems::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDataTransferItems::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDataTransferItemsPrototype::create(exec->globalData(), globalObject, JSDataTransferItemsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSDataTransferItems::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDataTransferItemsTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DataTransferItems*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSDataTransferItems, Base>(exec, &JSDataTransferItemsTable, this, propertyName, slot);
}

bool JSDataTransferItems::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDataTransferItemsTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DataTransferItems*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSDataTransferItems, Base>(exec, &JSDataTransferItemsTable, this, propertyName, descriptor);
}

bool JSDataTransferItems::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (propertyName < static_cast<DataTransferItems*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDataTransferItemsLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataTransferItems* castedThis = static_cast<JSDataTransferItems*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataTransferItems* imp = static_cast<DataTransferItems*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsDataTransferItemsConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataTransferItems* domObject = static_cast<JSDataTransferItems*>(asObject(slotBase));
    return JSDataTransferItems::getConstructor(exec, domObject->globalObject());
}

void JSDataTransferItems::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    for (unsigned i = 0; i < static_cast<DataTransferItems*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDataTransferItems::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataTransferItemsConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDataTransferItemsPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataTransferItems::s_info))
        return throwVMTypeError(exec);
    JSDataTransferItems* castedThis = static_cast<JSDataTransferItems*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataTransferItems::s_info);
    DataTransferItems* imp = static_cast<DataTransferItems*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataTransferItemsPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataTransferItems::s_info))
        return throwVMTypeError(exec);
    JSDataTransferItems* castedThis = static_cast<JSDataTransferItems*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataTransferItems::s_info);
    DataTransferItems* imp = static_cast<DataTransferItems*>(castedThis->impl());

    imp->clear();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferItemsPrototypeFunctionAdd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataTransferItems::s_info))
        return throwVMTypeError(exec);
    JSDataTransferItems* castedThis = static_cast<JSDataTransferItems*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataTransferItems::s_info);
    DataTransferItems* imp = static_cast<DataTransferItems*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& data(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& type(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->add(data, type, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


JSValue JSDataTransferItems::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDataTransferItems* thisObj = static_cast<JSDataTransferItems*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<DataTransferItems*>(thisObj->impl())->item(index));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DataTransferItems* impl)
{
    return wrap<JSDataTransferItems>(exec, globalObject, impl);
}

DataTransferItems* toDataTransferItems(JSC::JSValue value)
{
    return value.inherits(&JSDataTransferItems::s_info) ? static_cast<JSDataTransferItems*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATA_TRANSFER_ITEMS)
