/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMTokenList.h"

#include "DOMTokenList.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMTokenList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMTokenListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMTokenListLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMTokenListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMTokenListTable = { 5, 3, JSDOMTokenListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMTokenListConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMTokenListConstructorTable = { 1, 0, JSDOMTokenListConstructorTableValues, 0 };
class JSDOMTokenListConstructor : public DOMConstructorObject {
private:
    JSDOMTokenListConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDOMTokenListConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDOMTokenListConstructor* ptr = new (JSC::allocateCell<JSDOMTokenListConstructor>(*exec->heap())) JSDOMTokenListConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMTokenListConstructor::s_info = { "DOMTokenListConstructor", &DOMConstructorObject::s_info, &JSDOMTokenListConstructorTable, 0 };

JSDOMTokenListConstructor::JSDOMTokenListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMTokenListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMTokenListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMTokenListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMTokenListConstructor, JSDOMWrapper>(exec, &JSDOMTokenListConstructorTable, this, propertyName, slot);
}

bool JSDOMTokenListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMTokenListConstructor, JSDOMWrapper>(exec, &JSDOMTokenListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMTokenListPrototypeTableValues[] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "contains", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionContains), (intptr_t)1 THUNK_GENERATOR(0) },
    { "add", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionAdd), (intptr_t)1 THUNK_GENERATOR(0) },
    { "remove", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionRemove), (intptr_t)1 THUNK_GENERATOR(0) },
    { "toggle", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionToggle), (intptr_t)1 THUNK_GENERATOR(0) },
    { "toString", DontDelete | DontEnum | Function, (intptr_t)static_cast<NativeFunction>(jsDOMTokenListPrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMTokenListPrototypeTable = { 16, 15, JSDOMTokenListPrototypeTableValues, 0 };
const ClassInfo JSDOMTokenListPrototype::s_info = { "DOMTokenListPrototype", &JSC::JSNonFinalObject::s_info, &JSDOMTokenListPrototypeTable, 0 };

JSObject* JSDOMTokenListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMTokenList>(exec, globalObject);
}

bool JSDOMTokenListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMTokenListPrototypeTable, this, propertyName, slot);
}

bool JSDOMTokenListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMTokenListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMTokenList::s_info = { "DOMTokenList", &JSDOMWrapper::s_info, &JSDOMTokenListTable, 0 };

JSDOMTokenList::JSDOMTokenList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMTokenList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSDOMTokenList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMTokenList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMTokenListPrototype::create(exec->globalData(), globalObject, JSDOMTokenListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSDOMTokenList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDOMTokenListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMTokenList, Base>(exec, &JSDOMTokenListTable, this, propertyName, slot);
}

bool JSDOMTokenList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDOMTokenListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DOMTokenList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSDOMTokenList, Base>(exec, &JSDOMTokenListTable, this, propertyName, descriptor);
}

bool JSDOMTokenList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (propertyName < static_cast<DOMTokenList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDOMTokenListLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsDOMTokenListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMTokenList* domObject = static_cast<JSDOMTokenList*>(asObject(slotBase));
    return JSDOMTokenList::getConstructor(exec, domObject->globalObject());
}

void JSDOMTokenList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    for (unsigned i = 0; i < static_cast<DOMTokenList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDOMTokenList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMTokenListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsStringOrNull(exec, imp->item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionContains(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& token(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->contains(token, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionAdd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& token(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->add(token, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& token(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->remove(token, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionToggle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& token(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->toggle(token, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMTokenListPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMTokenList::s_info))
        return throwVMTypeError(exec);
    JSDOMTokenList* castedThis = static_cast<JSDOMTokenList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMTokenList::s_info);
    DOMTokenList* imp = static_cast<DOMTokenList*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return JSValue::encode(result);
}


JSValue JSDOMTokenList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMTokenList* thisObj = static_cast<JSDOMTokenList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return jsStringOrNull(exec, thisObj->impl()->item(index));
}

static inline bool isObservable(JSDOMTokenList* jsDOMTokenList)
{
    if (jsDOMTokenList->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMTokenListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMTokenList* jsDOMTokenList = static_cast<JSDOMTokenList*>(handle.get().asCell());
    if (!isObservable(jsDOMTokenList))
        return false;
    Element* element = jsDOMTokenList->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSDOMTokenListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMTokenList* jsDOMTokenList = static_cast<JSDOMTokenList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMTokenList->impl(), jsDOMTokenList);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMTokenList* impl)
{
    return wrap<JSDOMTokenList>(exec, globalObject, impl);
}

DOMTokenList* toDOMTokenList(JSC::JSValue value)
{
    return value.inherits(&JSDOMTokenList::s_info) ? static_cast<JSDOMTokenList*>(asObject(value))->impl() : 0;
}

}
