/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSConsole_h
#define JSConsole_h

#include "Console.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSConsole : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSConsole* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Console> impl)
    {
        JSConsole* ptr = new (JSC::allocateCell<JSConsole>(globalObject->globalData().heap)) JSConsole(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }


    // Custom attributes
    JSC::JSValue profiles(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue profile(JSC::ExecState*);
    JSC::JSValue profileEnd(JSC::ExecState*);
    Console* impl() const { return m_impl.get(); }

private:
    RefPtr<Console> m_impl;
protected:
    JSConsole(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<Console>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSConsoleOwner : public JSC::WeakHandleOwner {
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, Console*)
{
    DEFINE_STATIC_LOCAL(JSConsoleOwner, jsConsoleOwner, ());
    return &jsConsoleOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, Console*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, Console*);
Console* toConsole(JSC::JSValue);

class JSConsolePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSConsolePrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSConsolePrototype* ptr = new (JSC::allocateCell<JSConsolePrototype>(globalData.heap)) JSConsolePrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSConsolePrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDebug(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionError(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionInfo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionLog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionWarn(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDir(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDirxml(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTrace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionAssert(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionCount(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionMarkTimeline(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfile(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfileEnd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTimeEnd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTimeStamp(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroup(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupCollapsed(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupEnd(JSC::ExecState*);
// Attributes

JSC::JSValue jsConsoleProfiles(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsConsoleMemory(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif
