/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMediaRule.h"

#include "CSSMediaRule.h"
#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSRuleList.h"
#include "JSDOMBinding.h"
#include "JSMediaList.h"
#include "MediaList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSMediaRule);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSMediaRuleTableValues[] =
{
    { "media", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSMediaRuleMedia), (intptr_t)0 THUNK_GENERATOR(0) },
    { "cssRules", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSMediaRuleCssRules), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSMediaRuleConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSMediaRuleTable = { 8, 7, JSCSSMediaRuleTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSMediaRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSMediaRuleConstructorTable = { 1, 0, JSCSSMediaRuleConstructorTableValues, 0 };
class JSCSSMediaRuleConstructor : public DOMConstructorObject {
private:
    JSCSSMediaRuleConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSCSSMediaRuleConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSCSSMediaRuleConstructor* ptr = new (JSC::allocateCell<JSCSSMediaRuleConstructor>(*exec->heap())) JSCSSMediaRuleConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSMediaRuleConstructor::s_info = { "CSSMediaRuleConstructor", &DOMConstructorObject::s_info, &JSCSSMediaRuleConstructorTable, 0 };

JSCSSMediaRuleConstructor::JSCSSMediaRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSMediaRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSMediaRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSMediaRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRuleConstructor, JSDOMWrapper>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, slot);
}

bool JSCSSMediaRuleConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSMediaRuleConstructor, JSDOMWrapper>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSMediaRulePrototypeTableValues[] =
{
    { "insertRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSMediaRulePrototypeFunctionInsertRule), (intptr_t)2 THUNK_GENERATOR(0) },
    { "deleteRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSMediaRulePrototypeFunctionDeleteRule), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSMediaRulePrototypeTable = { 4, 3, JSCSSMediaRulePrototypeTableValues, 0 };
const ClassInfo JSCSSMediaRulePrototype::s_info = { "CSSMediaRulePrototype", &JSC::JSNonFinalObject::s_info, &JSCSSMediaRulePrototypeTable, 0 };

JSObject* JSCSSMediaRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSMediaRule>(exec, globalObject);
}

bool JSCSSMediaRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, slot);
}

bool JSCSSMediaRulePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCSSMediaRule::s_info = { "CSSMediaRule", &JSCSSRule::s_info, &JSCSSMediaRuleTable, 0 };

JSCSSMediaRule::JSCSSMediaRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSMediaRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSCSSMediaRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSMediaRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSMediaRulePrototype::create(exec->globalData(), globalObject, JSCSSMediaRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSMediaRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, slot);
}

bool JSCSSMediaRule::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, descriptor);
}

JSValue jsCSSMediaRuleMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
    return result;
}


JSValue jsCSSMediaRuleCssRules(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->cssRules()));
    return result;
}


JSValue jsCSSMediaRuleConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSMediaRule* domObject = static_cast<JSCSSMediaRule*>(asObject(slotBase));
    return JSCSSMediaRule::getConstructor(exec, domObject->globalObject());
}

JSValue JSCSSMediaRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSMediaRuleConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSMediaRulePrototypeFunctionInsertRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSMediaRule::s_info))
        return throwVMTypeError(exec);
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSMediaRule::s_info);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& rule(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSMediaRulePrototypeFunctionDeleteRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSMediaRule::s_info))
        return throwVMTypeError(exec);
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSMediaRule::s_info);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
