/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParam.h"

#include "AudioParam.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAudioParam);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioParamTableValues[] =
{
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamValue), (intptr_t)setJSAudioParamValue THUNK_GENERATOR(0) },
    { "minValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMinValue), (intptr_t)0 THUNK_GENERATOR(0) },
    { "maxValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMaxValue), (intptr_t)0 THUNK_GENERATOR(0) },
    { "defaultValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamDefaultValue), (intptr_t)0 THUNK_GENERATOR(0) },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "units", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamUnits), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioParamTable = { 18, 15, JSAudioParamTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioParamConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioParamConstructorTable = { 1, 0, JSAudioParamConstructorTableValues, 0 };
class JSAudioParamConstructor : public DOMConstructorObject {
private:
    JSAudioParamConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSAudioParamConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSAudioParamConstructor* ptr = new (JSC::allocateCell<JSAudioParamConstructor>(*exec->heap())) JSAudioParamConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSAudioParamConstructor::s_info = { "AudioParamConstructor", &DOMConstructorObject::s_info, &JSAudioParamConstructorTable, 0 };

JSAudioParamConstructor::JSAudioParamConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAudioParamConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSAudioParamPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSAudioParamConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAudioParamConstructor, JSDOMWrapper>(exec, &JSAudioParamConstructorTable, this, propertyName, slot);
}

bool JSAudioParamConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAudioParamConstructor, JSDOMWrapper>(exec, &JSAudioParamConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioParamPrototypeTableValues[] =
{
    { "setValueAtTime", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueAtTime), (intptr_t)2 THUNK_GENERATOR(0) },
    { "linearRampToValueAtTime", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionLinearRampToValueAtTime), (intptr_t)2 THUNK_GENERATOR(0) },
    { "exponentialRampToValueAtTime", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionExponentialRampToValueAtTime), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setTargetValueAtTime", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetTargetValueAtTime), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setValueCurveAtTime", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueCurveAtTime), (intptr_t)3 THUNK_GENERATOR(0) },
    { "cancelScheduledValues", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionCancelScheduledValues), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioParamPrototypeTable = { 18, 15, JSAudioParamPrototypeTableValues, 0 };
const ClassInfo JSAudioParamPrototype::s_info = { "AudioParamPrototype", &JSC::JSNonFinalObject::s_info, &JSAudioParamPrototypeTable, 0 };

JSObject* JSAudioParamPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioParam>(exec, globalObject);
}

bool JSAudioParamPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSAudioParamPrototypeTable, this, propertyName, slot);
}

bool JSAudioParamPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAudioParamPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSAudioParam::s_info = { "AudioParam", &JSDOMWrapper::s_info, &JSAudioParamTable, 0 };

JSAudioParam::JSAudioParam(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioParam> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSAudioParam::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioParam::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioParamPrototype::create(exec->globalData(), globalObject, JSAudioParamPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSAudioParam::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSAudioParam, Base>(exec, &JSAudioParamTable, this, propertyName, slot);
}

bool JSAudioParam::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSAudioParam, Base>(exec, &JSAudioParamTable, this, propertyName, descriptor);
}

JSValue jsAudioParamValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(imp->value());
    return result;
}


JSValue jsAudioParamMinValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(imp->minValue());
    return result;
}


JSValue jsAudioParamMaxValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(imp->maxValue());
    return result;
}


JSValue jsAudioParamDefaultValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(imp->defaultValue());
    return result;
}


JSValue jsAudioParamName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsAudioParamUnits(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(imp->units());
    return result;
}


JSValue jsAudioParamConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioParam* domObject = static_cast<JSAudioParam*>(asObject(slotBase));
    return JSAudioParam::getConstructor(exec, domObject->globalObject());
}

void JSAudioParam::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSAudioParam, Base>(exec, propertyName, value, &JSAudioParamTable, this, slot);
}

void setJSAudioParamValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(thisObject);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    imp->setValue(value.toFloat(exec));
}


JSValue JSAudioParam::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioParamConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionLinearRampToValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->linearRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionExponentialRampToValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->exponentialRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    float targetValue(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float timeConstant(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setTargetValueAtTime(targetValue, time, timeConstant);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueCurveAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    Float32Array* values(toFloat32Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float duration(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setValueCurveAtTime(values, time, duration);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionCancelScheduledValues(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = static_cast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* imp = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    float startTime(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->cancelScheduledValues(startTime);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioParam* impl)
{
    return wrap<JSAudioParam>(exec, globalObject, impl);
}

AudioParam* toAudioParam(JSC::JSValue value)
{
    return value.inherits(&JSAudioParam::s_info) ? static_cast<JSAudioParam*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_AUDIO)
