/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSAbstractWorker.h"

#include "AbstractWorker.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAbstractWorker);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAbstractWorkerTableValues[] =
{
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAbstractWorkerOnerror), (intptr_t)setJSAbstractWorkerOnerror THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAbstractWorkerConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerTable = { 4, 3, JSAbstractWorkerTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAbstractWorkerConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerConstructorTable = { 1, 0, JSAbstractWorkerConstructorTableValues, 0 };
class JSAbstractWorkerConstructor : public DOMConstructorObject {
private:
    JSAbstractWorkerConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSAbstractWorkerConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSAbstractWorkerConstructor* ptr = new (JSC::allocateCell<JSAbstractWorkerConstructor>(*exec->heap())) JSAbstractWorkerConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSAbstractWorkerConstructor::s_info = { "AbstractWorkerConstructor", &DOMConstructorObject::s_info, &JSAbstractWorkerConstructorTable, 0 };

JSAbstractWorkerConstructor::JSAbstractWorkerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAbstractWorkerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSAbstractWorkerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSAbstractWorkerConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAbstractWorkerConstructor, JSDOMWrapper>(exec, &JSAbstractWorkerConstructorTable, this, propertyName, slot);
}

bool JSAbstractWorkerConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAbstractWorkerConstructor, JSDOMWrapper>(exec, &JSAbstractWorkerConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAbstractWorkerPrototypeTableValues[] =
{
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerPrototypeTable = { 8, 7, JSAbstractWorkerPrototypeTableValues, 0 };
const ClassInfo JSAbstractWorkerPrototype::s_info = { "AbstractWorkerPrototype", &JSC::JSNonFinalObject::s_info, &JSAbstractWorkerPrototypeTable, 0 };

JSObject* JSAbstractWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAbstractWorker>(exec, globalObject);
}

bool JSAbstractWorkerPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSAbstractWorkerPrototypeTable, this, propertyName, slot);
}

bool JSAbstractWorkerPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAbstractWorkerPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSAbstractWorker::s_info = { "AbstractWorker", &JSDOMWrapper::s_info, &JSAbstractWorkerTable, 0 };

JSAbstractWorker::JSAbstractWorker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AbstractWorker> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSAbstractWorker::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSAbstractWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAbstractWorkerPrototype::create(exec->globalData(), globalObject, JSAbstractWorkerPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSAbstractWorker::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, this, propertyName, slot);
}

bool JSAbstractWorker::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, this, propertyName, descriptor);
}

JSValue jsAbstractWorkerOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsAbstractWorkerConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAbstractWorker* domObject = static_cast<JSAbstractWorker*>(asObject(slotBase));
    return JSAbstractWorker::getConstructor(exec, domObject->globalObject());
}

void JSAbstractWorker::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSAbstractWorker, Base>(exec, propertyName, value, &JSAbstractWorkerTable, this, slot);
}

void setJSAbstractWorkerOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(thisObject);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSAbstractWorker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAbstractWorkerConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSAbstractWorker::visitChildren(SlotVisitor& visitor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(visitor);
    impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSAbstractWorker* jsAbstractWorker)
{
    if (jsAbstractWorker->hasCustomProperties())
        return true;
    if (jsAbstractWorker->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSAbstractWorkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAbstractWorker* jsAbstractWorker = static_cast<JSAbstractWorker*>(handle.get().asCell());
    if (jsAbstractWorker->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsAbstractWorker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSAbstractWorkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAbstractWorker* jsAbstractWorker = static_cast<JSAbstractWorker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAbstractWorker->impl(), jsAbstractWorker);
}

AbstractWorker* toAbstractWorker(JSC::JSValue value)
{
    return value.inherits(&JSAbstractWorker::s_info) ? static_cast<JSAbstractWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
