/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSXPathResult_h
#define JSXPathResult_h

#if ENABLE(XPATH)

#include "JSDOMBinding.h"
#include "XPathResult.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSXPathResult : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSXPathResult* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XPathResult> impl)
    {
        JSXPathResult* ptr = new (JSC::allocateCell<JSXPathResult>(globalObject->globalData().heap)) JSXPathResult(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual void visitChildren(JSC::SlotVisitor&);

    XPathResult* impl() const { return m_impl.get(); }

private:
    RefPtr<XPathResult> m_impl;
protected:
    JSXPathResult(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<XPathResult>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, XPathResult*);
XPathResult* toXPathResult(JSC::JSValue);

class JSXPathResultPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSXPathResultPrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathResultPrototype* ptr = new (JSC::allocateCell<JSXPathResultPrototype>(globalData.heap)) JSXPathResultPrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSXPathResultPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionIterateNext(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionSnapshotItem(JSC::ExecState*);
// Attributes

JSC::JSValue jsXPathResultResultType(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultNumberValue(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultStringValue(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultBooleanValue(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultSingleNodeValue(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultInvalidIteratorState(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultSnapshotLength(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
// Constants

JSC::JSValue jsXPathResultANY_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultNUMBER_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultSTRING_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultBOOLEAN_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultUNORDERED_NODE_ITERATOR_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultORDERED_NODE_ITERATOR_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultORDERED_NODE_SNAPSHOT_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultANY_UNORDERED_NODE_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsXPathResultFIRST_ORDERED_NODE_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(XPATH)

#endif
