/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWorkerContext_h
#define JSWorkerContext_h

#if ENABLE(WORKERS)

#include "JSWorkerContextBase.h"
#include <runtime/JSObject.h>

namespace WebCore {

class WorkerContext;

class JSWorkerContext : public JSWorkerContextBase {
public:
    typedef JSWorkerContextBase Base;
    static JSWorkerContext* create(JSC::JSGlobalData& globalData, JSC::Structure* structure, PassRefPtr<WorkerContext> impl)
    {
        JSWorkerContext* ptr = new (JSC::allocateCell<JSWorkerContext>(globalData.heap)) JSWorkerContext(globalData, structure, impl);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    bool getOwnPropertySlotDelegate(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    bool getOwnPropertyDescriptorDelegate(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    virtual void visitChildren(JSC::SlotVisitor&);


    // Custom attributes
    JSC::JSValue messageChannel(JSC::ExecState*) const;
    JSC::JSValue eventSource(JSC::ExecState*) const;
    JSC::JSValue xmlHttpRequest(JSC::ExecState*) const;
    JSC::JSValue webSocket(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue importScripts(JSC::ExecState*);
    JSC::JSValue setTimeout(JSC::ExecState*);
    JSC::JSValue setInterval(JSC::ExecState*);
protected:
    JSWorkerContext(JSC::JSGlobalData&, JSC::Structure*, PassRefPtr<WorkerContext>);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};


class JSWorkerContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWorkerContextPrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWorkerContextPrototype* ptr = new (JSC::allocateCell<JSWorkerContextPrototype>(globalData.heap)) JSWorkerContextPrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSWorkerContextPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionImportScripts(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionOpenDatabase(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionOpenDatabaseSync(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionSetTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClearTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionSetInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClearInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsWorkerContextSelf(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextLocation(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextOnerror(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextNavigator(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextWebkitNotifications(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerContextMessageEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextWorkerLocationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextWorkerLocationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextMessageChannelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextMessageChannelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextEventSourceConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextEventSourceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextWebSocketConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextWebSocketConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextWebKitBlobBuilderConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextWebKitBlobBuilderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextFileReaderConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextFileReaderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextFileReaderSyncConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextFileReaderSyncConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextWebkitURL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerContextArrayBufferConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextArrayBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextInt8ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextInt8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextUint8ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextUint8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextInt16ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextInt16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextUint16ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextUint16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextInt32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextInt32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextUint32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextUint32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextFloat32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextFloat32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextFloat64ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextFloat64ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWorkerContextDataViewConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSWorkerContextDataViewConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif // ENABLE(WORKERS)

#endif
