/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebKitLoseContext.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "WebKitLoseContext.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitLoseContext);

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitLoseContextPrototypeTableValues[] =
{
    { "loseContext", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitLoseContextPrototypeFunctionLoseContext), (intptr_t)0 THUNK_GENERATOR(0) },
    { "restoreContext", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitLoseContextPrototypeFunctionRestoreContext), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitLoseContextPrototypeTable = { 4, 3, JSWebKitLoseContextPrototypeTableValues, 0 };
const ClassInfo JSWebKitLoseContextPrototype::s_info = { "WebKitLoseContextPrototype", &JSC::JSNonFinalObject::s_info, &JSWebKitLoseContextPrototypeTable, 0 };

JSObject* JSWebKitLoseContextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitLoseContext>(exec, globalObject);
}

bool JSWebKitLoseContextPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitLoseContextPrototypeTable, this, propertyName, slot);
}

bool JSWebKitLoseContextPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitLoseContextPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitLoseContext::s_info = { "WebKitLoseContext", &JSDOMWrapper::s_info, 0, 0 };

JSWebKitLoseContext::JSWebKitLoseContext(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitLoseContext> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebKitLoseContext::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitLoseContext::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitLoseContextPrototype::create(exec->globalData(), globalObject, JSWebKitLoseContextPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

EncodedJSValue JSC_HOST_CALL jsWebKitLoseContextPrototypeFunctionLoseContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitLoseContext::s_info))
        return throwVMTypeError(exec);
    JSWebKitLoseContext* castedThis = static_cast<JSWebKitLoseContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitLoseContext::s_info);
    WebKitLoseContext* imp = static_cast<WebKitLoseContext*>(castedThis->impl());

    imp->loseContext();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitLoseContextPrototypeFunctionRestoreContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitLoseContext::s_info))
        return throwVMTypeError(exec);
    JSWebKitLoseContext* castedThis = static_cast<JSWebKitLoseContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitLoseContext::s_info);
    WebKitLoseContext* imp = static_cast<WebKitLoseContext*>(castedThis->impl());

    imp->restoreContext();
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSWebKitLoseContext* jsWebKitLoseContext)
{
    if (jsWebKitLoseContext->hasCustomProperties())
        return true;
    return false;
}

bool JSWebKitLoseContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebKitLoseContext* jsWebKitLoseContext = static_cast<JSWebKitLoseContext*>(handle.get().asCell());
    if (!isObservable(jsWebKitLoseContext))
        return false;
    WebGLRenderingContext* root = jsWebKitLoseContext->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSWebKitLoseContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebKitLoseContext* jsWebKitLoseContext = static_cast<JSWebKitLoseContext*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitLoseContext->impl(), jsWebKitLoseContext);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitLoseContext* impl)
{
    return wrap<JSWebKitLoseContext>(exec, globalObject, impl);
}

WebKitLoseContext* toWebKitLoseContext(JSC::JSValue value)
{
    return value.inherits(&JSWebKitLoseContext::s_info) ? static_cast<JSWebKitLoseContext*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
