/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSWebKitFlags.h"

#include "WebKitFlags.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitFlags);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitFlagsTableValues[] =
{
    { "create", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitFlagsCreate), (intptr_t)setJSWebKitFlagsCreate THUNK_GENERATOR(0) },
    { "exclusive", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitFlagsExclusive), (intptr_t)setJSWebKitFlagsExclusive THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitFlagsConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitFlagsTable = { 9, 7, JSWebKitFlagsTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitFlagsConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitFlagsConstructorTable = { 1, 0, JSWebKitFlagsConstructorTableValues, 0 };
class JSWebKitFlagsConstructor : public DOMConstructorObject {
private:
    JSWebKitFlagsConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebKitFlagsConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebKitFlagsConstructor* ptr = new (JSC::allocateCell<JSWebKitFlagsConstructor>(*exec->heap())) JSWebKitFlagsConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSWebKitFlags(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

const ClassInfo JSWebKitFlagsConstructor::s_info = { "WebKitFlagsConstructor", &DOMConstructorObject::s_info, &JSWebKitFlagsConstructorTable, 0 };

JSWebKitFlagsConstructor::JSWebKitFlagsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitFlagsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitFlagsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitFlagsConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitFlagsConstructor, JSDOMWrapper>(exec, &JSWebKitFlagsConstructorTable, this, propertyName, slot);
}

bool JSWebKitFlagsConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitFlagsConstructor, JSDOMWrapper>(exec, &JSWebKitFlagsConstructorTable, this, propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSWebKitFlagsConstructor::constructJSWebKitFlags(ExecState* exec)
{
    return JSValue::encode(asObject(toJS(exec, static_cast<JSWebKitFlagsConstructor*>(exec->callee())->globalObject(), WebKitFlags::create())));
}

ConstructType JSWebKitFlagsConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSWebKitFlags;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitFlagsPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitFlagsPrototypeTable = { 1, 0, JSWebKitFlagsPrototypeTableValues, 0 };
static const HashTable* getJSWebKitFlagsPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebKitFlagsPrototypeTable);
}

const ClassInfo JSWebKitFlagsPrototype::s_info = { "WebKitFlagsPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSWebKitFlagsPrototypeTable };

JSObject* JSWebKitFlagsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitFlags>(exec, globalObject);
}

static const HashTable* getJSWebKitFlagsTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebKitFlagsTable);
}

const ClassInfo JSWebKitFlags::s_info = { "WebKitFlags", &JSDOMWrapper::s_info, 0, getJSWebKitFlagsTable };

JSWebKitFlags::JSWebKitFlags(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitFlags> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebKitFlags::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitFlags::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitFlagsPrototype::create(exec->globalData(), globalObject, JSWebKitFlagsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebKitFlags::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebKitFlags, Base>(exec, getJSWebKitFlagsTable(exec), this, propertyName, slot);
}

bool JSWebKitFlags::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebKitFlags, Base>(exec, getJSWebKitFlagsTable(exec), this, propertyName, descriptor);
}

JSValue jsWebKitFlagsCreate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitFlags* castedThis = static_cast<JSWebKitFlags*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitFlags* imp = static_cast<WebKitFlags*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isCreate());
    return result;
}


JSValue jsWebKitFlagsExclusive(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitFlags* castedThis = static_cast<JSWebKitFlags*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitFlags* imp = static_cast<WebKitFlags*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isExclusive());
    return result;
}


JSValue jsWebKitFlagsConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitFlags* domObject = static_cast<JSWebKitFlags*>(asObject(slotBase));
    return JSWebKitFlags::getConstructor(exec, domObject->globalObject());
}

void JSWebKitFlags::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSWebKitFlags, Base>(exec, propertyName, value, getJSWebKitFlagsTable(exec), this, slot);
}

void setJSWebKitFlagsCreate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitFlags* castedThis = static_cast<JSWebKitFlags*>(thisObject);
    WebKitFlags* imp = static_cast<WebKitFlags*>(castedThis->impl());
    imp->setCreate(value.toBoolean(exec));
}


void setJSWebKitFlagsExclusive(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitFlags* castedThis = static_cast<JSWebKitFlags*>(thisObject);
    WebKitFlags* imp = static_cast<WebKitFlags*>(castedThis->impl());
    imp->setExclusive(value.toBoolean(exec));
}


JSValue JSWebKitFlags::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitFlagsConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitFlags* impl)
{
    return wrap<JSWebKitFlags>(exec, globalObject, impl);
}

WebKitFlags* toWebKitFlags(JSC::JSValue value)
{
    return value.inherits(&JSWebKitFlags::s_info) ? static_cast<JSWebKitFlags*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
