/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitBlobBuilder.h"

#include "Blob.h"
#include "ExceptionCode.h"
#include "JSArrayBuffer.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "WebKitBlobBuilder.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitBlobBuilder);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitBlobBuilderTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitBlobBuilderConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitBlobBuilderTable = { 2, 1, JSWebKitBlobBuilderTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitBlobBuilderConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitBlobBuilderConstructorTable = { 1, 0, JSWebKitBlobBuilderConstructorTableValues, 0 };
class JSWebKitBlobBuilderConstructor : public DOMConstructorObject {
private:
    JSWebKitBlobBuilderConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebKitBlobBuilderConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebKitBlobBuilderConstructor* ptr = new (JSC::allocateCell<JSWebKitBlobBuilderConstructor>(*exec->heap())) JSWebKitBlobBuilderConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSWebKitBlobBuilder(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

const ClassInfo JSWebKitBlobBuilderConstructor::s_info = { "WebKitBlobBuilderConstructor", &DOMConstructorObject::s_info, &JSWebKitBlobBuilderConstructorTable, 0 };

JSWebKitBlobBuilderConstructor::JSWebKitBlobBuilderConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitBlobBuilderConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitBlobBuilderPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitBlobBuilderConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitBlobBuilderConstructor, JSDOMWrapper>(exec, &JSWebKitBlobBuilderConstructorTable, this, propertyName, slot);
}

bool JSWebKitBlobBuilderConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitBlobBuilderConstructor, JSDOMWrapper>(exec, &JSWebKitBlobBuilderConstructorTable, this, propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSWebKitBlobBuilderConstructor::constructJSWebKitBlobBuilder(ExecState* exec)
{
    return JSValue::encode(asObject(toJS(exec, static_cast<JSWebKitBlobBuilderConstructor*>(exec->callee())->globalObject(), WebKitBlobBuilder::create())));
}

ConstructType JSWebKitBlobBuilderConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSWebKitBlobBuilder;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitBlobBuilderPrototypeTableValues[] =
{
#if ENABLE(BLOB)
    { "getBlob", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitBlobBuilderPrototypeFunctionGetBlob), (intptr_t)1 THUNK_GENERATOR(0) },
    { "append", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitBlobBuilderPrototypeFunctionAppend), (intptr_t)1 THUNK_GENERATOR(0) },
#endif
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitBlobBuilderPrototypeTable = { 8, 7, JSWebKitBlobBuilderPrototypeTableValues, 0 };
static const HashTable* getJSWebKitBlobBuilderPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebKitBlobBuilderPrototypeTable);
}

const ClassInfo JSWebKitBlobBuilderPrototype::s_info = { "WebKitBlobBuilderPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSWebKitBlobBuilderPrototypeTable };

JSObject* JSWebKitBlobBuilderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitBlobBuilder>(exec, globalObject);
}

bool JSWebKitBlobBuilderPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSWebKitBlobBuilderPrototypeTable(exec), this, propertyName, slot);
}

bool JSWebKitBlobBuilderPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSWebKitBlobBuilderPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSWebKitBlobBuilderTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebKitBlobBuilderTable);
}

const ClassInfo JSWebKitBlobBuilder::s_info = { "WebKitBlobBuilder", &JSDOMWrapper::s_info, 0, getJSWebKitBlobBuilderTable };

JSWebKitBlobBuilder::JSWebKitBlobBuilder(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitBlobBuilder> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebKitBlobBuilder::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitBlobBuilder::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitBlobBuilderPrototype::create(exec->globalData(), globalObject, JSWebKitBlobBuilderPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebKitBlobBuilder::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebKitBlobBuilder, Base>(exec, getJSWebKitBlobBuilderTable(exec), this, propertyName, slot);
}

bool JSWebKitBlobBuilder::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebKitBlobBuilder, Base>(exec, getJSWebKitBlobBuilderTable(exec), this, propertyName, descriptor);
}

JSValue jsWebKitBlobBuilderConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitBlobBuilder* domObject = static_cast<JSWebKitBlobBuilder*>(asObject(slotBase));
    return JSWebKitBlobBuilder::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitBlobBuilder::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitBlobBuilderConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitBlobBuilderPrototypeFunctionGetBlob(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSWebKitBlobBuilder* castedThis = static_cast<JSWebKitBlobBuilder*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitBlobBuilder::s_info);
    WebKitBlobBuilder* imp = static_cast<WebKitBlobBuilder*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getBlob()));
        return JSValue::encode(result);
    }

    const String& contentType(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getBlob(contentType)));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsWebKitBlobBuilderPrototypeFunctionAppend1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSWebKitBlobBuilder* castedThis = static_cast<JSWebKitBlobBuilder*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitBlobBuilder::s_info);
    WebKitBlobBuilder* imp = static_cast<WebKitBlobBuilder*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->append(blob);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(BLOB)
static EncodedJSValue JSC_HOST_CALL jsWebKitBlobBuilderPrototypeFunctionAppend2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSWebKitBlobBuilder* castedThis = static_cast<JSWebKitBlobBuilder*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitBlobBuilder::s_info);
    WebKitBlobBuilder* imp = static_cast<WebKitBlobBuilder*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ArrayBuffer* arrayBuffer(toArrayBuffer(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->append(arrayBuffer);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsWebKitBlobBuilderPrototypeFunctionAppend3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSWebKitBlobBuilder* castedThis = static_cast<JSWebKitBlobBuilder*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitBlobBuilder::s_info);
    WebKitBlobBuilder* imp = static_cast<WebKitBlobBuilder*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& value(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        imp->append(value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    const String& endings(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->append(value, endings, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitBlobBuilderPrototypeFunctionAppend(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSBlob::s_info)))))
        return jsWebKitBlobBuilderPrototypeFunctionAppend1(exec);
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSArrayBuffer::s_info)))))
        return jsWebKitBlobBuilderPrototypeFunctionAppend2(exec);
    JSValue arg1(exec->argument(1));
    if ((argsCount == 1 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())) || (argsCount == 2 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject()) && (arg1.isUndefinedOrNull() || arg1.isString() || arg1.isObject())))
        return jsWebKitBlobBuilderPrototypeFunctionAppend3(exec);
    return throwVMTypeError(exec);
}
#endif

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitBlobBuilder* impl)
{
    return wrap<JSWebKitBlobBuilder>(exec, globalObject, impl);
}

WebKitBlobBuilder* toWebKitBlobBuilder(JSC::JSValue value)
{
    return value.inherits(&JSWebKitBlobBuilder::s_info) ? static_cast<JSWebKitBlobBuilder*>(asObject(value))->impl() : 0;
}

}
