/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "WebGLContextEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLContextEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLContextEventTableValues[] =
{
    { "statusMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventStatusMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLContextEventTable = { 4, 3, JSWebGLContextEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLContextEventConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLContextEventConstructorTable = { 1, 0, JSWebGLContextEventConstructorTableValues, 0 };
class JSWebGLContextEventConstructor : public DOMConstructorObject {
private:
    JSWebGLContextEventConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebGLContextEventConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebGLContextEventConstructor* ptr = new (JSC::allocateCell<JSWebGLContextEventConstructor>(*exec->heap())) JSWebGLContextEventConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebGLContextEventConstructor::s_info = { "WebGLContextEventConstructor", &DOMConstructorObject::s_info, &JSWebGLContextEventConstructorTable, 0 };

JSWebGLContextEventConstructor::JSWebGLContextEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLContextEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLContextEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLContextEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLContextEventConstructor, JSDOMWrapper>(exec, &JSWebGLContextEventConstructorTable, this, propertyName, slot);
}

bool JSWebGLContextEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLContextEventConstructor, JSDOMWrapper>(exec, &JSWebGLContextEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLContextEventPrototypeTableValues[] =
{
    { "initEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebGLContextEventPrototypeFunctionInitEvent), (intptr_t)4 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLContextEventPrototypeTable = { 2, 1, JSWebGLContextEventPrototypeTableValues, 0 };
const ClassInfo JSWebGLContextEventPrototype::s_info = { "WebGLContextEventPrototype", &JSC::JSNonFinalObject::s_info, &JSWebGLContextEventPrototypeTable, 0 };

JSObject* JSWebGLContextEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextEvent>(exec, globalObject);
}

bool JSWebGLContextEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebGLContextEventPrototypeTable, this, propertyName, slot);
}

bool JSWebGLContextEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebGLContextEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebGLContextEvent::s_info = { "WebGLContextEvent", &JSEvent::s_info, &JSWebGLContextEventTable, 0 };

JSWebGLContextEvent::JSWebGLContextEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLContextEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSWebGLContextEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLContextEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLContextEventPrototype::create(exec->globalData(), globalObject, JSWebGLContextEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSWebGLContextEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebGLContextEvent, Base>(exec, &JSWebGLContextEventTable, this, propertyName, slot);
}

bool JSWebGLContextEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebGLContextEvent, Base>(exec, &JSWebGLContextEventTable, this, propertyName, descriptor);
}

JSValue jsWebGLContextEventStatusMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextEvent* castedThis = static_cast<JSWebGLContextEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextEvent* imp = static_cast<WebGLContextEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->statusMessage());
    return result;
}


JSValue jsWebGLContextEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextEvent* domObject = static_cast<JSWebGLContextEvent*>(asObject(slotBase));
    return JSWebGLContextEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLContextEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLContextEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebGLContextEventPrototypeFunctionInitEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebGLContextEvent::s_info))
        return throwVMTypeError(exec);
    JSWebGLContextEvent* castedThis = static_cast<JSWebGLContextEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebGLContextEvent::s_info);
    WebGLContextEvent* imp = static_cast<WebGLContextEvent*>(castedThis->impl());
    const String& eventTypeArg(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& statusMessageArg(ustringToString(exec->argument(3).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initEvent(eventTypeArg, canBubbleArg, cancelableArg, statusMessageArg);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(WEBGL)
