/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextAttributes.h"

#include "WebGLContextAttributes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLContextAttributes);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLContextAttributesTableValues[] =
{
    { "alpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAlpha), (intptr_t)setJSWebGLContextAttributesAlpha THUNK_GENERATOR(0) },
    { "depth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesDepth), (intptr_t)setJSWebGLContextAttributesDepth THUNK_GENERATOR(0) },
    { "stencil", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesStencil), (intptr_t)setJSWebGLContextAttributesStencil THUNK_GENERATOR(0) },
    { "antialias", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAntialias), (intptr_t)setJSWebGLContextAttributesAntialias THUNK_GENERATOR(0) },
    { "premultipliedAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPremultipliedAlpha), (intptr_t)setJSWebGLContextAttributesPremultipliedAlpha THUNK_GENERATOR(0) },
    { "preserveDrawingBuffer", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPreserveDrawingBuffer), (intptr_t)setJSWebGLContextAttributesPreserveDrawingBuffer THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLContextAttributesTable = { 16, 15, JSWebGLContextAttributesTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLContextAttributesPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLContextAttributesPrototypeTable = { 1, 0, JSWebGLContextAttributesPrototypeTableValues, 0 };
const ClassInfo JSWebGLContextAttributesPrototype::s_info = { "WebGLContextAttributesPrototype", &JSC::JSNonFinalObject::s_info, &JSWebGLContextAttributesPrototypeTable, 0 };

JSObject* JSWebGLContextAttributesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextAttributes>(exec, globalObject);
}

const ClassInfo JSWebGLContextAttributes::s_info = { "WebGLContextAttributes", &JSDOMWrapper::s_info, &JSWebGLContextAttributesTable, 0 };

JSWebGLContextAttributes::JSWebGLContextAttributes(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLContextAttributes> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebGLContextAttributes::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLContextAttributes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLContextAttributesPrototype::create(exec->globalData(), globalObject, JSWebGLContextAttributesPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebGLContextAttributes::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, this, propertyName, slot);
}

bool JSWebGLContextAttributes::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, this, propertyName, descriptor);
}

JSValue jsWebGLContextAttributesAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->alpha());
    return result;
}


JSValue jsWebGLContextAttributesDepth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->depth());
    return result;
}


JSValue jsWebGLContextAttributesStencil(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->stencil());
    return result;
}


JSValue jsWebGLContextAttributesAntialias(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->antialias());
    return result;
}


JSValue jsWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->premultipliedAlpha());
    return result;
}


JSValue jsWebGLContextAttributesPreserveDrawingBuffer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->preserveDrawingBuffer());
    return result;
}


void JSWebGLContextAttributes::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSWebGLContextAttributes, Base>(exec, propertyName, value, &JSWebGLContextAttributesTable, this, slot);
}

void setJSWebGLContextAttributesAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setAlpha(value.toBoolean(exec));
}


void setJSWebGLContextAttributesDepth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setDepth(value.toBoolean(exec));
}


void setJSWebGLContextAttributesStencil(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setStencil(value.toBoolean(exec));
}


void setJSWebGLContextAttributesAntialias(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setAntialias(value.toBoolean(exec));
}


void setJSWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setPremultipliedAlpha(value.toBoolean(exec));
}


void setJSWebGLContextAttributesPreserveDrawingBuffer(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    imp->setPreserveDrawingBuffer(value.toBoolean(exec));
}


JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLContextAttributes* impl)
{
    return wrap<JSWebGLContextAttributes>(exec, globalObject, impl);
}

WebGLContextAttributes* toWebGLContextAttributes(JSC::JSValue value)
{
    return value.inherits(&JSWebGLContextAttributes::s_info) ? static_cast<JSWebGLContextAttributes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
