/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSText.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSText.h"
#include "KURL.h"
#include "Text.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSText);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTextTableValues[] =
{
    { "wholeText", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextWholeText), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTextTable = { 5, 3, JSTextTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTextConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTextConstructorTable = { 1, 0, JSTextConstructorTableValues, 0 };
class JSTextConstructor : public DOMConstructorObject {
private:
    JSTextConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSTextConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSTextConstructor* ptr = new (JSC::allocateCell<JSTextConstructor>(*exec->heap())) JSTextConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSTextConstructor::s_info = { "TextConstructor", &DOMConstructorObject::s_info, &JSTextConstructorTable, 0 };

JSTextConstructor::JSTextConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSTextPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSTextConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextConstructor, JSDOMWrapper>(exec, &JSTextConstructorTable, this, propertyName, slot);
}

bool JSTextConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextConstructor, JSDOMWrapper>(exec, &JSTextConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTextPrototypeTableValues[] =
{
    { "splitText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionSplitText), (intptr_t)1 THUNK_GENERATOR(0) },
    { "replaceWholeText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionReplaceWholeText), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTextPrototypeTable = { 4, 3, JSTextPrototypeTableValues, 0 };
const ClassInfo JSTextPrototype::s_info = { "TextPrototype", &JSC::JSNonFinalObject::s_info, &JSTextPrototypeTable, 0 };

JSObject* JSTextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSText>(exec, globalObject);
}

bool JSTextPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTextPrototypeTable, this, propertyName, slot);
}

bool JSTextPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSText::s_info = { "Text", &JSCharacterData::s_info, &JSTextTable, 0 };

JSText::JSText(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Text> impl)
    : JSCharacterData(structure, globalObject, impl)
{
}

void JSText::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSText::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextPrototype::create(exec->globalData(), globalObject, JSTextPrototype::createStructure(exec->globalData(), globalObject, JSCharacterDataPrototype::self(exec, globalObject)));
}

bool JSText::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSText, Base>(exec, &JSTextTable, this, propertyName, slot);
}

bool JSText::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSText, Base>(exec, &JSTextTable, this, propertyName, descriptor);
}

JSValue jsTextWholeText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSText* castedThis = static_cast<JSText*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Text* imp = static_cast<Text*>(castedThis->impl());
    JSValue result = jsString(exec, imp->wholeText());
    return result;
}


JSValue jsTextConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSText* domObject = static_cast<JSText*>(asObject(slotBase));
    return JSText::getConstructor(exec, domObject->globalObject());
}

JSValue JSText::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionSplitText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSText::s_info))
        return throwVMTypeError(exec);
    JSText* castedThis = static_cast<JSText*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSText::s_info);
    Text* imp = static_cast<Text*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(exec->argument(0).toUInt32(exec));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->splitText(offset, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionReplaceWholeText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSText::s_info))
        return throwVMTypeError(exec);
    JSText* castedThis = static_cast<JSText*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSText::s_info);
    Text* imp = static_cast<Text*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& content(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->replaceWholeText(content, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
