/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSScriptProfileNode_h
#define JSScriptProfileNode_h

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSDOMBinding.h"
#include "ScriptProfileNode.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSScriptProfileNode : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSScriptProfileNode* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ScriptProfileNode> impl)
    {
        JSScriptProfileNode* ptr = new (JSC::allocateCell<JSScriptProfileNode>(globalObject->globalData().heap)) JSScriptProfileNode(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }


    // Custom attributes
    JSC::JSValue children(JSC::ExecState*) const;
    JSC::JSValue callUID(JSC::ExecState*) const;
    ScriptProfileNode* impl() const { return m_impl.get(); }

private:
    RefPtr<ScriptProfileNode> m_impl;
protected:
    JSScriptProfileNode(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<ScriptProfileNode>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, ScriptProfileNode*);
ScriptProfileNode* toScriptProfileNode(JSC::JSValue);

class JSScriptProfileNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSScriptProfileNodePrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScriptProfileNodePrototype* ptr = new (JSC::allocateCell<JSScriptProfileNodePrototype>(globalData.heap)) JSScriptProfileNodePrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSScriptProfileNodePrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = Base::StructureFlags;
};

// Attributes

JSC::JSValue jsScriptProfileNodeFunctionName(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeUrl(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeLineNumber(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeTotalTime(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeSelfTime(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeNumberOfCalls(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeChildren(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeVisible(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsScriptProfileNodeCallUID(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#endif
