/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGUnitTypes.h"

#include "SVGUnitTypes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGUnitTypes);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGUnitTypesTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGUnitTypesTable = { 2, 1, JSSVGUnitTypesTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGUnitTypesConstructorTableValues[] =
{
    { "SVG_UNIT_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_UNIT_TYPE_USERSPACEONUSE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGUnitTypesConstructorTable = { 8, 7, JSSVGUnitTypesConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGUnitTypes::SVG_UNIT_TYPE_UNKNOWN, SVGUnitTypesEnumSVG_UNIT_TYPE_UNKNOWNIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == SVGUnitTypes::SVG_UNIT_TYPE_USERSPACEONUSE, SVGUnitTypesEnumSVG_UNIT_TYPE_USERSPACEONUSEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == SVGUnitTypes::SVG_UNIT_TYPE_OBJECTBOUNDINGBOX, SVGUnitTypesEnumSVG_UNIT_TYPE_OBJECTBOUNDINGBOXIsWrongUseDontCheckEnums);

class JSSVGUnitTypesConstructor : public DOMConstructorObject {
private:
    JSSVGUnitTypesConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGUnitTypesConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGUnitTypesConstructor* ptr = new (JSC::allocateCell<JSSVGUnitTypesConstructor>(*exec->heap())) JSSVGUnitTypesConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGUnitTypesConstructor::s_info = { "SVGUnitTypesConstructor", &DOMConstructorObject::s_info, &JSSVGUnitTypesConstructorTable, 0 };

JSSVGUnitTypesConstructor::JSSVGUnitTypesConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGUnitTypesConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGUnitTypesPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGUnitTypesConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGUnitTypesConstructor, JSDOMWrapper>(exec, &JSSVGUnitTypesConstructorTable, this, propertyName, slot);
}

bool JSSVGUnitTypesConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGUnitTypesConstructor, JSDOMWrapper>(exec, &JSSVGUnitTypesConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGUnitTypesPrototypeTableValues[] =
{
    { "SVG_UNIT_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_UNIT_TYPE_USERSPACEONUSE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGUnitTypesPrototypeTable = { 8, 7, JSSVGUnitTypesPrototypeTableValues, 0 };
const ClassInfo JSSVGUnitTypesPrototype::s_info = { "SVGUnitTypesPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGUnitTypesPrototypeTable, 0 };

JSObject* JSSVGUnitTypesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGUnitTypes>(exec, globalObject);
}

bool JSSVGUnitTypesPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGUnitTypesPrototype, JSObject>(exec, &JSSVGUnitTypesPrototypeTable, this, propertyName, slot);
}

bool JSSVGUnitTypesPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGUnitTypesPrototype, JSObject>(exec, &JSSVGUnitTypesPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGUnitTypes::s_info = { "SVGUnitTypes", &JSDOMWrapper::s_info, &JSSVGUnitTypesTable, 0 };

JSSVGUnitTypes::JSSVGUnitTypes(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGUnitTypes> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSSVGUnitTypes::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGUnitTypes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGUnitTypesPrototype::create(exec->globalData(), globalObject, JSSVGUnitTypesPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSSVGUnitTypes::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGUnitTypes, Base>(exec, &JSSVGUnitTypesTable, this, propertyName, slot);
}

bool JSSVGUnitTypes::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGUnitTypes, Base>(exec, &JSSVGUnitTypesTable, this, propertyName, descriptor);
}

JSValue jsSVGUnitTypesConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGUnitTypes* domObject = static_cast<JSSVGUnitTypes*>(asObject(slotBase));
    return JSSVGUnitTypes::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGUnitTypes::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGUnitTypesConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_USERSPACEONUSE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGUnitTypesSVG_UNIT_TYPE_OBJECTBOUNDINGBOX(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGUnitTypes* impl)
{
    return wrap<JSSVGUnitTypes>(exec, globalObject, impl);
}

SVGUnitTypes* toSVGUnitTypes(JSC::JSValue value)
{
    return value.inherits(&JSSVGUnitTypes::s_info) ? static_cast<JSSVGUnitTypes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
