/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextPathElement.h"

#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGTextPathElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTextPathElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTextPathElementTableValues[] =
{
    { "startOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementStartOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "method", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "spacing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementSpacing), (intptr_t)0 THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementTable = { 16, 15, JSSVGTextPathElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTextPathElementConstructorTableValues[] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementConstructorTable = { 18, 15, JSSVGTextPathElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGTextPathElement::TEXTPATH_METHODTYPE_UNKNOWN, SVGTextPathElementEnumTEXTPATH_METHODTYPE_UNKNOWNIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == SVGTextPathElement::TEXTPATH_METHODTYPE_ALIGN, SVGTextPathElementEnumTEXTPATH_METHODTYPE_ALIGNIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == SVGTextPathElement::TEXTPATH_METHODTYPE_STRETCH, SVGTextPathElementEnumTEXTPATH_METHODTYPE_STRETCHIsWrongUseDontCheckEnums);
COMPILE_ASSERT(0 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_UNKNOWN, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_UNKNOWNIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_AUTO, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_AUTOIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == SVGTextPathElement::TEXTPATH_SPACINGTYPE_EXACT, SVGTextPathElementEnumTEXTPATH_SPACINGTYPE_EXACTIsWrongUseDontCheckEnums);

class JSSVGTextPathElementConstructor : public DOMConstructorObject {
private:
    JSSVGTextPathElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGTextPathElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGTextPathElementConstructor* ptr = new (JSC::allocateCell<JSSVGTextPathElementConstructor>(*exec->heap())) JSSVGTextPathElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGTextPathElementConstructor::s_info = { "SVGTextPathElementConstructor", &DOMConstructorObject::s_info, &JSSVGTextPathElementConstructorTable, 0 };

JSSVGTextPathElementConstructor::JSSVGTextPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTextPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTextPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTextPathElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPathElementConstructorTable, this, propertyName, slot);
}

bool JSSVGTextPathElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPathElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTextPathElementPrototypeTableValues[] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementPrototypeTable = { 18, 15, JSSVGTextPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTextPathElementPrototype::s_info = { "SVGTextPathElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGTextPathElementPrototypeTable, 0 };

JSObject* JSSVGTextPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextPathElement>(exec, globalObject);
}

bool JSSVGTextPathElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGTextPathElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGTextPathElement::s_info = { "SVGTextPathElement", &JSSVGTextContentElement::s_info, &JSSVGTextPathElementTable, 0 };

JSSVGTextPathElement::JSSVGTextPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextPathElement> impl)
    : JSSVGTextContentElement(structure, globalObject, impl)
{
}

void JSSVGTextPathElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTextPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTextPathElementPrototype::create(exec->globalData(), globalObject, JSSVGTextPathElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGTextContentElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextPathElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, this, propertyName, slot);
}

bool JSSVGTextPathElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, this, propertyName, descriptor);
}

JSValue jsSVGTextPathElementStartOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->startOffsetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementMethod(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->methodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementSpacing(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->spacingAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPathElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* domObject = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    return JSSVGTextPathElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTextPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPathElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
