/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGScriptElement.h"

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGScriptElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGScriptElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGScriptElementTableValues[] =
{
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementType), (intptr_t)setJSSVGScriptElementType THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementExternalResourcesRequired), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGScriptElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGScriptElementTable = { 9, 7, JSSVGScriptElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGScriptElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGScriptElementConstructorTable = { 1, 0, JSSVGScriptElementConstructorTableValues, 0 };
class JSSVGScriptElementConstructor : public DOMConstructorObject {
private:
    JSSVGScriptElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGScriptElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGScriptElementConstructor* ptr = new (JSC::allocateCell<JSSVGScriptElementConstructor>(*exec->heap())) JSSVGScriptElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGScriptElementConstructor::s_info = { "SVGScriptElementConstructor", &DOMConstructorObject::s_info, &JSSVGScriptElementConstructorTable, 0 };

JSSVGScriptElementConstructor::JSSVGScriptElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGScriptElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGScriptElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGScriptElementConstructor, JSDOMWrapper>(exec, &JSSVGScriptElementConstructorTable, this, propertyName, slot);
}

bool JSSVGScriptElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGScriptElementConstructor, JSDOMWrapper>(exec, &JSSVGScriptElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGScriptElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGScriptElementPrototypeTable = { 1, 0, JSSVGScriptElementPrototypeTableValues, 0 };
const ClassInfo JSSVGScriptElementPrototype::s_info = { "SVGScriptElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGScriptElementPrototypeTable, 0 };

JSObject* JSSVGScriptElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGScriptElement>(exec, globalObject);
}

const ClassInfo JSSVGScriptElement::s_info = { "SVGScriptElement", &JSSVGElement::s_info, &JSSVGScriptElementTable, 0 };

JSSVGScriptElement::JSSVGScriptElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGScriptElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGScriptElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGScriptElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGScriptElementPrototype::create(exec->globalData(), globalObject, JSSVGScriptElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGScriptElement, Base>(exec, &JSSVGScriptElementTable, this, propertyName, slot);
}

bool JSSVGScriptElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGScriptElement, Base>(exec, &JSSVGScriptElementTable, this, propertyName, descriptor);
}

JSValue jsSVGScriptElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGScriptElement* castedThis = static_cast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* imp = static_cast<SVGScriptElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}


JSValue jsSVGScriptElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGScriptElement* castedThis = static_cast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* imp = static_cast<SVGScriptElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGScriptElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGScriptElement* castedThis = static_cast<JSSVGScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGScriptElement* imp = static_cast<SVGScriptElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGScriptElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGScriptElement* domObject = static_cast<JSSVGScriptElement*>(asObject(slotBase));
    return JSSVGScriptElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGScriptElement, Base>(exec, propertyName, value, &JSSVGScriptElementTable, this, slot);
}

void setJSSVGScriptElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGScriptElement* castedThis = static_cast<JSSVGScriptElement*>(thisObject);
    SVGScriptElement* imp = static_cast<SVGScriptElement*>(castedThis->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}


JSValue JSSVGScriptElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGScriptElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
