/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGGradientElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "SVGGradientElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGGradientElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGradientElementTableValues[] =
{
    { "gradientUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientUnits), (intptr_t)0 THUNK_GENERATOR(0) },
    { "gradientTransform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientTransform), (intptr_t)0 THUNK_GENERATOR(0) },
    { "spreadMethod", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSpreadMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementExternalResourcesRequired), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementTable = { 16, 15, JSSVGGradientElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGradientElementConstructorTableValues[] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_PAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementConstructorTable = { 8, 7, JSSVGGradientElementConstructorTableValues, 0 };
class JSSVGGradientElementConstructor : public DOMConstructorObject {
private:
    JSSVGGradientElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGGradientElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGGradientElementConstructor* ptr = new (JSC::allocateCell<JSSVGGradientElementConstructor>(*exec->heap())) JSSVGGradientElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGGradientElementConstructor::s_info = { "SVGGradientElementConstructor", &DOMConstructorObject::s_info, &JSSVGGradientElementConstructorTable, 0 };

JSSVGGradientElementConstructor::JSSVGGradientElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGGradientElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGGradientElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGGradientElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGGradientElementConstructorTable, this, propertyName, slot);
}

bool JSSVGGradientElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGGradientElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGradientElementPrototypeTableValues[] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_PAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGGradientElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementPrototypeTable = { 17, 15, JSSVGGradientElementPrototypeTableValues, 0 };
const ClassInfo JSSVGGradientElementPrototype::s_info = { "SVGGradientElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGGradientElementPrototypeTable, 0 };

JSObject* JSSVGGradientElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGradientElement>(exec, globalObject);
}

bool JSSVGGradientElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGGradientElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGGradientElement::s_info = { "SVGGradientElement", &JSSVGElement::s_info, &JSSVGGradientElementTable, 0 };

JSSVGGradientElement::JSSVGGradientElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGradientElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGGradientElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGGradientElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGGradientElementPrototype::create(exec->globalData(), globalObject, JSSVGGradientElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGGradientElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, this, propertyName, slot);
}

bool JSSVGGradientElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, this, propertyName, descriptor);
}

JSValue jsSVGGradientElementGradientUnits(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->gradientUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementGradientTransform(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->gradientTransformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementSpreadMethod(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->spreadMethodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGGradientElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* domObject = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    return JSSVGGradientElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGGradientElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGradientElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGGradientElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGradientElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGradientElement::s_info);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_PAD(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REFLECT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REPEAT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
