/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFESpecularLightingElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFESpecularLightingElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFESpecularLightingElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFESpecularLightingElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementIn1), (intptr_t)0 THUNK_GENERATOR(0) },
    { "surfaceScale", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSurfaceScale), (intptr_t)0 THUNK_GENERATOR(0) },
    { "specularConstant", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSpecularConstant), (intptr_t)0 THUNK_GENERATOR(0) },
    { "specularExponent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSpecularExponent), (intptr_t)0 THUNK_GENERATOR(0) },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementResult), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFESpecularLightingElementTable = { 36, 31, JSSVGFESpecularLightingElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFESpecularLightingElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFESpecularLightingElementConstructorTable = { 1, 0, JSSVGFESpecularLightingElementConstructorTableValues, 0 };
class JSSVGFESpecularLightingElementConstructor : public DOMConstructorObject {
private:
    JSSVGFESpecularLightingElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGFESpecularLightingElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGFESpecularLightingElementConstructor* ptr = new (JSC::allocateCell<JSSVGFESpecularLightingElementConstructor>(*exec->heap())) JSSVGFESpecularLightingElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFESpecularLightingElementConstructor::s_info = { "SVGFESpecularLightingElementConstructor", &DOMConstructorObject::s_info, &JSSVGFESpecularLightingElementConstructorTable, 0 };

JSSVGFESpecularLightingElementConstructor::JSSVGFESpecularLightingElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFESpecularLightingElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFESpecularLightingElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFESpecularLightingElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFESpecularLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFESpecularLightingElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFESpecularLightingElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFESpecularLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFESpecularLightingElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFESpecularLightingElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGFESpecularLightingElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFESpecularLightingElementPrototypeTable = { 2, 1, JSSVGFESpecularLightingElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFESpecularLightingElementPrototype::s_info = { "SVGFESpecularLightingElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGFESpecularLightingElementPrototypeTable, 0 };

JSObject* JSSVGFESpecularLightingElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFESpecularLightingElement>(exec, globalObject);
}

bool JSSVGFESpecularLightingElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFESpecularLightingElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFESpecularLightingElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFESpecularLightingElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFESpecularLightingElement::s_info = { "SVGFESpecularLightingElement", &JSSVGElement::s_info, &JSSVGFESpecularLightingElementTable, 0 };

JSSVGFESpecularLightingElement::JSSVGFESpecularLightingElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFESpecularLightingElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFESpecularLightingElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFESpecularLightingElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFESpecularLightingElementPrototype::create(exec->globalData(), globalObject, JSSVGFESpecularLightingElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFESpecularLightingElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGFESpecularLightingElement, Base>(exec, &JSSVGFESpecularLightingElementTable, this, propertyName, slot);
}

bool JSSVGFESpecularLightingElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGFESpecularLightingElement, Base>(exec, &JSSVGFESpecularLightingElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFESpecularLightingElementIn1(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSurfaceScale(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->surfaceScaleAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSpecularConstant(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->specularConstantAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSpecularExponent(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->specularExponentAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGFESpecularLightingElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpecularLightingElement* domObject = static_cast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    return JSSVGFESpecularLightingElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFESpecularLightingElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFESpecularLightingElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFESpecularLightingElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFESpecularLightingElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFESpecularLightingElement* castedThis = static_cast<JSSVGFESpecularLightingElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFESpecularLightingElement::s_info);
    SVGFESpecularLightingElement* imp = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
