/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEColorMatrixElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEColorMatrixElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEColorMatrixElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEColorMatrixElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementIn1), (intptr_t)0 THUNK_GENERATOR(0) },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementType), (intptr_t)0 THUNK_GENERATOR(0) },
    { "values", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementValues), (intptr_t)0 THUNK_GENERATOR(0) },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementResult), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementTable = { 34, 31, JSSVGFEColorMatrixElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEColorMatrixElementConstructorTableValues[] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementConstructorTable = { 17, 15, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
class JSSVGFEColorMatrixElementConstructor : public DOMConstructorObject {
private:
    JSSVGFEColorMatrixElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGFEColorMatrixElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGFEColorMatrixElementConstructor* ptr = new (JSC::allocateCell<JSSVGFEColorMatrixElementConstructor>(*exec->heap())) JSSVGFEColorMatrixElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFEColorMatrixElementConstructor::s_info = { "SVGFEColorMatrixElementConstructor", &DOMConstructorObject::s_info, &JSSVGFEColorMatrixElementConstructorTable, 0 };

JSSVGFEColorMatrixElementConstructor::JSSVGFEColorMatrixElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEColorMatrixElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEColorMatrixElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElementConstructor, JSDOMWrapper>(exec, &JSSVGFEColorMatrixElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEColorMatrixElementConstructor, JSDOMWrapper>(exec, &JSSVGFEColorMatrixElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEColorMatrixElementPrototypeTableValues[] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEColorMatrixElementPrototypeTable = { 17, 15, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEColorMatrixElementPrototype::s_info = { "SVGFEColorMatrixElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGFEColorMatrixElementPrototypeTable, 0 };

JSObject* JSSVGFEColorMatrixElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEColorMatrixElement>(exec, globalObject);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEColorMatrixElement::s_info = { "SVGFEColorMatrixElement", &JSSVGElement::s_info, &JSSVGFEColorMatrixElementTable, 0 };

JSSVGFEColorMatrixElement::JSSVGFEColorMatrixElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEColorMatrixElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEColorMatrixElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEColorMatrixElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEColorMatrixElementPrototype::create(exec->globalData(), globalObject, JSSVGFEColorMatrixElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEColorMatrixElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, this, propertyName, slot);
}

bool JSSVGFEColorMatrixElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEColorMatrixElementIn1(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->typeAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementValues(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumberList> obj = imp->valuesAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGFEColorMatrixElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEColorMatrixElement* domObject = static_cast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    return JSSVGFEColorMatrixElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEColorMatrixElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEColorMatrixElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEColorMatrixElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEColorMatrixElement* castedThis = static_cast<JSSVGFEColorMatrixElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEColorMatrixElement::s_info);
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
