/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(SVG_FONTS)

#include "JSSVGAltGlyphElement.h"

#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGAltGlyphElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAltGlyphElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGAltGlyphElementTableValues[] =
{
    { "glyphRef", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementGlyphRef), (intptr_t)setJSSVGAltGlyphElementGlyphRef THUNK_GENERATOR(0) },
    { "format", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementFormat), (intptr_t)setJSSVGAltGlyphElementFormat THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGAltGlyphElementTable = { 8, 7, JSSVGAltGlyphElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGAltGlyphElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGAltGlyphElementConstructorTable = { 1, 0, JSSVGAltGlyphElementConstructorTableValues, 0 };
class JSSVGAltGlyphElementConstructor : public DOMConstructorObject {
private:
    JSSVGAltGlyphElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGAltGlyphElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGAltGlyphElementConstructor* ptr = new (JSC::allocateCell<JSSVGAltGlyphElementConstructor>(*exec->heap())) JSSVGAltGlyphElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGAltGlyphElementConstructor::s_info = { "SVGAltGlyphElementConstructor", &DOMConstructorObject::s_info, &JSSVGAltGlyphElementConstructorTable, 0 };

JSSVGAltGlyphElementConstructor::JSSVGAltGlyphElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAltGlyphElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAltGlyphElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAltGlyphElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAltGlyphElementConstructor, JSDOMWrapper>(exec, &JSSVGAltGlyphElementConstructorTable, this, propertyName, slot);
}

bool JSSVGAltGlyphElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAltGlyphElementConstructor, JSDOMWrapper>(exec, &JSSVGAltGlyphElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGAltGlyphElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGAltGlyphElementPrototypeTable = { 1, 0, JSSVGAltGlyphElementPrototypeTableValues, 0 };
const ClassInfo JSSVGAltGlyphElementPrototype::s_info = { "SVGAltGlyphElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGAltGlyphElementPrototypeTable, 0 };

JSObject* JSSVGAltGlyphElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAltGlyphElement>(exec, globalObject);
}

const ClassInfo JSSVGAltGlyphElement::s_info = { "SVGAltGlyphElement", &JSSVGTextPositioningElement::s_info, &JSSVGAltGlyphElementTable, 0 };

JSSVGAltGlyphElement::JSSVGAltGlyphElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAltGlyphElement> impl)
    : JSSVGTextPositioningElement(structure, globalObject, impl)
{
}

void JSSVGAltGlyphElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAltGlyphElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAltGlyphElementPrototype::create(exec->globalData(), globalObject, JSSVGAltGlyphElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGTextPositioningElementPrototype::self(exec, globalObject)));
}

bool JSSVGAltGlyphElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGAltGlyphElement, Base>(exec, &JSSVGAltGlyphElementTable, this, propertyName, slot);
}

bool JSSVGAltGlyphElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGAltGlyphElement, Base>(exec, &JSSVGAltGlyphElementTable, this, propertyName, descriptor);
}

JSValue jsSVGAltGlyphElementGlyphRef(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAltGlyphElement* castedThis = static_cast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* imp = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->glyphRef());
    return result;
}


JSValue jsSVGAltGlyphElementFormat(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAltGlyphElement* castedThis = static_cast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* imp = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->format());
    return result;
}


JSValue jsSVGAltGlyphElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAltGlyphElement* castedThis = static_cast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* imp = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGAltGlyphElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAltGlyphElement* domObject = static_cast<JSSVGAltGlyphElement*>(asObject(slotBase));
    return JSSVGAltGlyphElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGAltGlyphElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGAltGlyphElement, Base>(exec, propertyName, value, &JSSVGAltGlyphElementTable, this, slot);
}

void setJSSVGAltGlyphElementGlyphRef(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGAltGlyphElement* castedThis = static_cast<JSSVGAltGlyphElement*>(thisObject);
    SVGAltGlyphElement* imp = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setGlyphRef(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}


void setJSSVGAltGlyphElementFormat(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGAltGlyphElement* castedThis = static_cast<JSSVGAltGlyphElement*>(thisObject);
    SVGAltGlyphElement* imp = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setFormat(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGAltGlyphElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAltGlyphElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FONTS)
