/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRange.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSRange);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRangeTableValues[] =
{
    { "startContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartContainer), (intptr_t)0 THUNK_GENERATOR(0) },
    { "startOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "endContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndContainer), (intptr_t)0 THUNK_GENERATOR(0) },
    { "endOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "collapsed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCollapsed), (intptr_t)0 THUNK_GENERATOR(0) },
    { "commonAncestorContainer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCommonAncestorContainer), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRangeTable = { 18, 15, JSRangeTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRangeConstructorTableValues[] =
{
    { "START_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_START), (intptr_t)0 THUNK_GENERATOR(0) },
    { "START_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_END), (intptr_t)0 THUNK_GENERATOR(0) },
    { "END_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_END), (intptr_t)0 THUNK_GENERATOR(0) },
    { "END_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_START), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_BEFORE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_AFTER), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE_AND_AFTER), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_INSIDE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_INSIDE), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRangeConstructorTable = { 18, 15, JSRangeConstructorTableValues, 0 };

COMPILE_ASSERT(0 == Range::START_TO_START, RangeEnumSTART_TO_STARTIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == Range::START_TO_END, RangeEnumSTART_TO_ENDIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == Range::END_TO_END, RangeEnumEND_TO_ENDIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == Range::END_TO_START, RangeEnumEND_TO_STARTIsWrongUseDontCheckEnums);
COMPILE_ASSERT(0 == Range::NODE_BEFORE, RangeEnumNODE_BEFOREIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == Range::NODE_AFTER, RangeEnumNODE_AFTERIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == Range::NODE_BEFORE_AND_AFTER, RangeEnumNODE_BEFORE_AND_AFTERIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == Range::NODE_INSIDE, RangeEnumNODE_INSIDEIsWrongUseDontCheckEnums);

class JSRangeConstructor : public DOMConstructorObject {
private:
    JSRangeConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSRangeConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSRangeConstructor* ptr = new (JSC::allocateCell<JSRangeConstructor>(*exec->heap())) JSRangeConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSRangeConstructor::s_info = { "RangeConstructor", &DOMConstructorObject::s_info, &JSRangeConstructorTable, 0 };

JSRangeConstructor::JSRangeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSRangeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSRangePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSRangeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeConstructor, JSDOMWrapper>(exec, &JSRangeConstructorTable, this, propertyName, slot);
}

bool JSRangeConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRangeConstructor, JSDOMWrapper>(exec, &JSRangeConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRangePrototypeTableValues[] =
{
    { "START_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_START), (intptr_t)0 THUNK_GENERATOR(0) },
    { "START_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeSTART_TO_END), (intptr_t)0 THUNK_GENERATOR(0) },
    { "END_TO_END", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_END), (intptr_t)0 THUNK_GENERATOR(0) },
    { "END_TO_START", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEND_TO_START), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_BEFORE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_AFTER), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_BEFORE_AND_AFTER), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NODE_INSIDE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeNODE_INSIDE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setStart", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStart), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setEnd", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEnd), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setStartBefore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartBefore), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setStartAfter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartAfter), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setEndBefore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndBefore), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setEndAfter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndAfter), (intptr_t)1 THUNK_GENERATOR(0) },
    { "collapse", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCollapse), (intptr_t)1 THUNK_GENERATOR(0) },
    { "selectNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "selectNodeContents", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNodeContents), (intptr_t)1 THUNK_GENERATOR(0) },
    { "compareBoundaryPoints", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareBoundaryPoints), (intptr_t)2 THUNK_GENERATOR(0) },
    { "deleteContents", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDeleteContents), (intptr_t)0 THUNK_GENERATOR(0) },
    { "extractContents", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExtractContents), (intptr_t)0 THUNK_GENERATOR(0) },
    { "cloneContents", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneContents), (intptr_t)0 THUNK_GENERATOR(0) },
    { "insertNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionInsertNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "surroundContents", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSurroundContents), (intptr_t)1 THUNK_GENERATOR(0) },
    { "cloneRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneRange), (intptr_t)0 THUNK_GENERATOR(0) },
    { "toString", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { "detach", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDetach), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getClientRects", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetClientRects), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getBoundingClientRect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetBoundingClientRect), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createContextualFragment", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCreateContextualFragment), (intptr_t)1 THUNK_GENERATOR(0) },
    { "intersectsNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIntersectsNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "compareNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "comparePoint", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionComparePoint), (intptr_t)2 THUNK_GENERATOR(0) },
    { "isPointInRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIsPointInRange), (intptr_t)2 THUNK_GENERATOR(0) },
    { "expand", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExpand), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRangePrototypeTable = { 132, 127, JSRangePrototypeTableValues, 0 };
const ClassInfo JSRangePrototype::s_info = { "RangePrototype", &JSC::JSNonFinalObject::s_info, &JSRangePrototypeTable, 0 };

JSObject* JSRangePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRange>(exec, globalObject);
}

bool JSRangePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangePrototype, JSObject>(exec, &JSRangePrototypeTable, this, propertyName, slot);
}

bool JSRangePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSRangePrototype, JSObject>(exec, &JSRangePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSRange::s_info = { "Range", &JSDOMWrapper::s_info, &JSRangeTable, 0 };

JSRange::JSRange(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Range> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSRange::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSRange::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSRangePrototype::create(exec->globalData(), globalObject, JSRangePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSRange::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSRange, Base>(exec, &JSRangeTable, this, propertyName, slot);
}

bool JSRange::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSRange, Base>(exec, &JSRangeTable, this, propertyName, descriptor);
}

JSValue jsRangeStartContainer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->startContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeStartOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsNumber(imp->startOffset(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeEndContainer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->endContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeEndOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsNumber(imp->endOffset(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeCollapsed(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = jsBoolean(imp->collapsed(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeCommonAncestorContainer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* castedThis = static_cast<JSRange*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Range* imp = static_cast<Range*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->commonAncestorContainer(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsRangeConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRange* domObject = static_cast<JSRange*>(asObject(slotBase));
    return JSRange::getConstructor(exec, domObject->globalObject());
}

JSValue JSRange::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRangeConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setStart(refNode, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setEnd(refNode, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setStartBefore(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartAfter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setStartAfter(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setEndBefore(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndAfter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setEndAfter(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCollapse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    bool toStart(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->collapse(toStart, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->selectNode(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNodeContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->selectNodeContents(refNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareBoundaryPoints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Range::CompareHow how(static_cast<Range::CompareHow>(exec->argument(0).toInt32(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* sourceRange(toRange(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->compareBoundaryPoints(how, sourceRange, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDeleteContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->deleteContents(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExtractContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->extractContents(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->cloneContents(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionInsertNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* newNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->insertNode(newNode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSurroundContents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* newParent(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->surroundContents(newParent, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->cloneRange(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = jsString(exec, imp->toString(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDetach(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->detach(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetClientRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getClientRects()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetBoundingClientRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getBoundingClientRect()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCreateContextualFragment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& html(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createContextualFragment(html, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIntersectsNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->intersectsNode(refNode, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->compareNode(refNode, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionComparePoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->comparePoint(refNode, offset, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIsPointInRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* refNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int offset(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->isPointInRange(refNode, offset, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExpand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRange::s_info))
        return throwVMTypeError(exec);
    JSRange* castedThis = static_cast<JSRange*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRange::s_info);
    Range* imp = static_cast<Range*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& unit(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->expand(unit, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsRangeSTART_TO_START(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsRangeSTART_TO_END(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsRangeEND_TO_END(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsRangeEND_TO_START(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsRangeNODE_BEFORE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsRangeNODE_AFTER(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsRangeNODE_BEFORE_AND_AFTER(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsRangeNODE_INSIDE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Range* impl)
{
    return wrap<JSRange>(exec, globalObject, impl);
}

Range* toRange(JSC::JSValue value)
{
    return value.inherits(&JSRange::s_info) ? static_cast<JSRange*>(asObject(value))->impl() : 0;
}

}
