/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSPositionError.h"

#include "KURL.h"
#include "PositionError.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPositionError);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPositionErrorTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorCode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPositionErrorTable = { 9, 7, JSPositionErrorTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPositionErrorConstructorTableValues[] =
{
    { "PERMISSION_DENIED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPERMISSION_DENIED), (intptr_t)0 THUNK_GENERATOR(0) },
    { "POSITION_UNAVAILABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPOSITION_UNAVAILABLE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorTIMEOUT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPositionErrorConstructorTable = { 9, 7, JSPositionErrorConstructorTableValues, 0 };

COMPILE_ASSERT(1 == PositionError::PERMISSION_DENIED, PositionErrorEnumPERMISSION_DENIEDIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == PositionError::POSITION_UNAVAILABLE, PositionErrorEnumPOSITION_UNAVAILABLEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == PositionError::TIMEOUT, PositionErrorEnumTIMEOUTIsWrongUseDontCheckEnums);

class JSPositionErrorConstructor : public DOMConstructorObject {
private:
    JSPositionErrorConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSPositionErrorConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSPositionErrorConstructor* ptr = new (JSC::allocateCell<JSPositionErrorConstructor>(*exec->heap())) JSPositionErrorConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPositionErrorConstructor::s_info = { "PositionErrorConstructor", &DOMConstructorObject::s_info, &JSPositionErrorConstructorTable, 0 };

JSPositionErrorConstructor::JSPositionErrorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPositionErrorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSPositionErrorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSPositionErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionErrorConstructor, JSDOMWrapper>(exec, &JSPositionErrorConstructorTable, this, propertyName, slot);
}

bool JSPositionErrorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPositionErrorConstructor, JSDOMWrapper>(exec, &JSPositionErrorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPositionErrorPrototypeTableValues[] =
{
    { "PERMISSION_DENIED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPERMISSION_DENIED), (intptr_t)0 THUNK_GENERATOR(0) },
    { "POSITION_UNAVAILABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPOSITION_UNAVAILABLE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorTIMEOUT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPositionErrorPrototypeTable = { 9, 7, JSPositionErrorPrototypeTableValues, 0 };
const ClassInfo JSPositionErrorPrototype::s_info = { "PositionErrorPrototype", &JSC::JSNonFinalObject::s_info, &JSPositionErrorPrototypeTable, 0 };

JSObject* JSPositionErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPositionError>(exec, globalObject);
}

bool JSPositionErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, this, propertyName, slot);
}

bool JSPositionErrorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPositionError::s_info = { "PositionError", &JSDOMWrapper::s_info, &JSPositionErrorTable, 0 };

JSPositionError::JSPositionError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PositionError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSPositionError::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSPositionError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPositionErrorPrototype::create(exec->globalData(), globalObject, JSPositionErrorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSPositionError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSPositionError, Base>(exec, &JSPositionErrorTable, this, propertyName, slot);
}

bool JSPositionError::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSPositionError, Base>(exec, &JSPositionErrorTable, this, propertyName, descriptor);
}

JSValue jsPositionErrorCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* castedThis = static_cast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* imp = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsNumber(imp->code());
    return result;
}


JSValue jsPositionErrorMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* castedThis = static_cast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* imp = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}


JSValue jsPositionErrorConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPositionError* domObject = static_cast<JSPositionError*>(asObject(slotBase));
    return JSPositionError::getConstructor(exec, domObject->globalObject());
}

JSValue JSPositionError::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPositionErrorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsPositionErrorPERMISSION_DENIED(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsPositionErrorPOSITION_UNAVAILABLE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsPositionErrorTIMEOUT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PositionError* impl)
{
    return wrap<JSPositionError>(exec, globalObject, impl);
}

PositionError* toPositionError(JSC::JSValue value)
{
    return value.inherits(&JSPositionError::s_info) ? static_cast<JSPositionError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
