/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSPeerConnection_h
#define JSPeerConnection_h

#if ENABLE(MEDIA_STREAM)

#include "JSDOMBinding.h"
#include "PeerConnection.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSPeerConnection : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSPeerConnection* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PeerConnection> impl)
    {
        JSPeerConnection* ptr = new (JSC::allocateCell<JSPeerConnection>(globalObject->globalData().heap)) JSPeerConnection(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual void visitChildren(JSC::SlotVisitor&);

    PeerConnection* impl() const { return m_impl.get(); }

private:
    RefPtr<PeerConnection> m_impl;
protected:
    JSPeerConnection(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<PeerConnection>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, PeerConnection*);
PeerConnection* toPeerConnection(JSC::JSValue);

class JSPeerConnectionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSPeerConnectionPrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPeerConnectionPrototype* ptr = new (JSC::allocateCell<JSPeerConnectionPrototype>(globalData.heap)) JSPeerConnectionPrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSPeerConnectionPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSPeerConnectionConstructor : public DOMConstructorObject {
private:
    JSPeerConnectionConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSPeerConnectionConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSPeerConnectionConstructor* ptr = new (JSC::allocateCell<JSPeerConnectionConstructor>(*exec->heap())) JSPeerConnectionConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSPeerConnection(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionProcessSignalingMessage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionSend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionAddStream(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionRemoveStream(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsPeerConnectionReadyState(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionLocalStreams(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionRemoteStreams(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionOnconnecting(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSPeerConnectionOnconnecting(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsPeerConnectionOnopen(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSPeerConnectionOnopen(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsPeerConnectionOnmessage(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSPeerConnectionOnmessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsPeerConnectionOnaddstream(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSPeerConnectionOnaddstream(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsPeerConnectionOnremovestream(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSPeerConnectionOnremovestream(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsPeerConnectionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
// Constants

JSC::JSValue jsPeerConnectionNEW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionNEGOTIATING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionACTIVE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsPeerConnectionCLOSED(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)

#endif
