/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSPeerConnection.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSMediaStream.h"
#include "JSMediaStreamList.h"
#include "MediaStreamList.h"
#include "PeerConnection.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPeerConnection);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPeerConnectionTableValues[] =
{
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionReadyState), (intptr_t)0 THUNK_GENERATOR(0) },
    { "localStreams", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionLocalStreams), (intptr_t)0 THUNK_GENERATOR(0) },
    { "remoteStreams", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionRemoteStreams), (intptr_t)0 THUNK_GENERATOR(0) },
    { "onconnecting", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionOnconnecting), (intptr_t)setJSPeerConnectionOnconnecting THUNK_GENERATOR(0) },
    { "onopen", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionOnopen), (intptr_t)setJSPeerConnectionOnopen THUNK_GENERATOR(0) },
    { "onmessage", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionOnmessage), (intptr_t)setJSPeerConnectionOnmessage THUNK_GENERATOR(0) },
    { "onaddstream", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionOnaddstream), (intptr_t)setJSPeerConnectionOnaddstream THUNK_GENERATOR(0) },
    { "onremovestream", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionOnremovestream), (intptr_t)setJSPeerConnectionOnremovestream THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPeerConnectionTable = { 34, 31, JSPeerConnectionTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPeerConnectionConstructorTableValues[] =
{
    { "NEW", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionNEW), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NEGOTIATING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionNEGOTIATING), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ACTIVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionACTIVE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CLOSED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionCLOSED), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPeerConnectionConstructorTable = { 8, 7, JSPeerConnectionConstructorTableValues, 0 };

COMPILE_ASSERT(0 == PeerConnection::NEW, PeerConnectionEnumNEWIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == PeerConnection::NEGOTIATING, PeerConnectionEnumNEGOTIATINGIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == PeerConnection::ACTIVE, PeerConnectionEnumACTIVEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == PeerConnection::CLOSED, PeerConnectionEnumCLOSEDIsWrongUseDontCheckEnums);

const ClassInfo JSPeerConnectionConstructor::s_info = { "PeerConnectionConstructor", &DOMConstructorObject::s_info, &JSPeerConnectionConstructorTable, 0 };

JSPeerConnectionConstructor::JSPeerConnectionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPeerConnectionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSPeerConnectionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSPeerConnectionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPeerConnectionConstructor, JSDOMWrapper>(exec, &JSPeerConnectionConstructorTable, this, propertyName, slot);
}

bool JSPeerConnectionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPeerConnectionConstructor, JSDOMWrapper>(exec, &JSPeerConnectionConstructorTable, this, propertyName, descriptor);
}

ConstructType JSPeerConnectionConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSPeerConnection;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPeerConnectionPrototypeTableValues[] =
{
    { "NEW", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionNEW), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NEGOTIATING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionNEGOTIATING), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ACTIVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionACTIVE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CLOSED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeerConnectionCLOSED), (intptr_t)0 THUNK_GENERATOR(0) },
    { "processSignalingMessage", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionProcessSignalingMessage), (intptr_t)1 THUNK_GENERATOR(0) },
    { "send", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionSend), (intptr_t)1 THUNK_GENERATOR(0) },
    { "addStream", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionAddStream), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeStream", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionRemoveStream), (intptr_t)1 THUNK_GENERATOR(0) },
    { "close", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionClose), (intptr_t)0 THUNK_GENERATOR(0) },
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPeerConnectionPrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPeerConnectionPrototypeTable = { 34, 31, JSPeerConnectionPrototypeTableValues, 0 };
const ClassInfo JSPeerConnectionPrototype::s_info = { "PeerConnectionPrototype", &JSC::JSNonFinalObject::s_info, &JSPeerConnectionPrototypeTable, 0 };

JSObject* JSPeerConnectionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPeerConnection>(exec, globalObject);
}

bool JSPeerConnectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSPeerConnectionPrototype, JSObject>(exec, &JSPeerConnectionPrototypeTable, this, propertyName, slot);
}

bool JSPeerConnectionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSPeerConnectionPrototype, JSObject>(exec, &JSPeerConnectionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPeerConnection::s_info = { "PeerConnection", &JSDOMWrapper::s_info, &JSPeerConnectionTable, 0 };

JSPeerConnection::JSPeerConnection(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PeerConnection> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSPeerConnection::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSPeerConnection::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPeerConnectionPrototype::create(exec->globalData(), globalObject, JSPeerConnectionPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSPeerConnection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSPeerConnection, Base>(exec, &JSPeerConnectionTable, this, propertyName, slot);
}

bool JSPeerConnection::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSPeerConnection, Base>(exec, &JSPeerConnectionTable, this, propertyName, descriptor);
}

JSValue jsPeerConnectionReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    JSValue result = jsNumber(imp->readyState());
    return result;
}


JSValue jsPeerConnectionLocalStreams(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->localStreams()));
    return result;
}


JSValue jsPeerConnectionRemoteStreams(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->remoteStreams()));
    return result;
}


JSValue jsPeerConnectionOnconnecting(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (EventListener* listener = imp->onconnecting()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsPeerConnectionOnopen(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (EventListener* listener = imp->onopen()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsPeerConnectionOnmessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (EventListener* listener = imp->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsPeerConnectionOnaddstream(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (EventListener* listener = imp->onaddstream()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsPeerConnectionOnremovestream(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (EventListener* listener = imp->onremovestream()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsPeerConnectionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPeerConnection* domObject = static_cast<JSPeerConnection*>(asObject(slotBase));
    return JSPeerConnection::getConstructor(exec, domObject->globalObject());
}

void JSPeerConnection::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSPeerConnection, Base>(exec, propertyName, value, &JSPeerConnectionTable, this, slot);
}

void setJSPeerConnectionOnconnecting(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(thisObject);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    imp->setOnconnecting(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSPeerConnectionOnopen(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(thisObject);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    imp->setOnopen(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSPeerConnectionOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(thisObject);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    imp->setOnmessage(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSPeerConnectionOnaddstream(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(thisObject);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    imp->setOnaddstream(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSPeerConnectionOnremovestream(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(thisObject);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    imp->setOnremovestream(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSPeerConnection::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPeerConnectionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionProcessSignalingMessage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& message(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->processSignalingMessage(message, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionSend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& text(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->send(text, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionAddStream(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSMediaStream::s_info))
        return throwVMTypeError(exec);
    MediaStream* stream(toMediaStream(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->addStream(stream, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionRemoveStream(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSMediaStream::s_info))
        return throwVMTypeError(exec);
    MediaStream* stream(toMediaStream(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->removeStream(stream, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->close(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPeerConnectionPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPeerConnection::s_info))
        return throwVMTypeError(exec);
    JSPeerConnection* castedThis = static_cast<JSPeerConnection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPeerConnection::s_info);
    PeerConnection* imp = static_cast<PeerConnection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Event* event(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSPeerConnection::visitChildren(SlotVisitor& visitor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(visitor);
    impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsPeerConnectionNEW(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsPeerConnectionNEGOTIATING(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsPeerConnectionACTIVE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsPeerConnectionCLOSED(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PeerConnection* impl)
{
    return wrap<JSPeerConnection>(exec, globalObject, impl);
}

PeerConnection* toPeerConnection(JSC::JSValue value)
{
    return value.inherits(&JSPeerConnection::s_info) ? static_cast<JSPeerConnection*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_STREAM)
