/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESStandardDerivatives.h"

#include "OESStandardDerivatives.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSOESStandardDerivatives);

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSOESStandardDerivativesPrototypeTableValues[] =
{
    { "FRAGMENT_SHADER_DERIVATIVE_HINT_OES", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOESStandardDerivativesFRAGMENT_SHADER_DERIVATIVE_HINT_OES), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSOESStandardDerivativesPrototypeTable = { 2, 1, JSOESStandardDerivativesPrototypeTableValues, 0 };
const ClassInfo JSOESStandardDerivativesPrototype::s_info = { "OESStandardDerivativesPrototype", &JSC::JSNonFinalObject::s_info, &JSOESStandardDerivativesPrototypeTable, 0 };

JSObject* JSOESStandardDerivativesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOESStandardDerivatives>(exec, globalObject);
}

bool JSOESStandardDerivativesPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOESStandardDerivativesPrototype, JSObject>(exec, &JSOESStandardDerivativesPrototypeTable, this, propertyName, slot);
}

bool JSOESStandardDerivativesPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOESStandardDerivativesPrototype, JSObject>(exec, &JSOESStandardDerivativesPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSOESStandardDerivatives::s_info = { "OESStandardDerivatives", &JSDOMWrapper::s_info, 0, 0 };

JSOESStandardDerivatives::JSOESStandardDerivatives(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OESStandardDerivatives> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSOESStandardDerivatives::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSOESStandardDerivatives::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOESStandardDerivativesPrototype::create(exec->globalData(), globalObject, JSOESStandardDerivativesPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

// Constant getters

JSValue jsOESStandardDerivativesFRAGMENT_SHADER_DERIVATIVE_HINT_OES(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8B8B));
}

static inline bool isObservable(JSOESStandardDerivatives* jsOESStandardDerivatives)
{
    if (jsOESStandardDerivatives->hasCustomProperties())
        return true;
    return false;
}

bool JSOESStandardDerivativesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSOESStandardDerivatives* jsOESStandardDerivatives = static_cast<JSOESStandardDerivatives*>(handle.get().asCell());
    if (!isObservable(jsOESStandardDerivatives))
        return false;
    WebGLRenderingContext* root = jsOESStandardDerivatives->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSOESStandardDerivativesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSOESStandardDerivatives* jsOESStandardDerivatives = static_cast<JSOESStandardDerivatives*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESStandardDerivatives->impl(), jsOESStandardDerivatives);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, OESStandardDerivatives* impl)
{
    return wrap<JSOESStandardDerivatives>(exec, globalObject, impl);
}

OESStandardDerivatives* toOESStandardDerivatives(JSC::JSValue value)
{
    return value.inherits(&JSOESStandardDerivatives::s_info) ? static_cast<JSOESStandardDerivatives*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
