/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaStream.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSMediaStreamTrackList.h"
#include "KURL.h"
#include "MediaStream.h"
#include "MediaStreamTrackList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaStream);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamTableValues[] =
{
    { "label", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamLabel), (intptr_t)0 THUNK_GENERATOR(0) },
    { "tracks", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTracks), (intptr_t)0 THUNK_GENERATOR(0) },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamReadyState), (intptr_t)0 THUNK_GENERATOR(0) },
    { "onended", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamOnended), (intptr_t)setJSMediaStreamOnended THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamTable = { 17, 15, JSMediaStreamTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamConstructorTableValues[] =
{
    { "LIVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamLIVE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ENDED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamENDED), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamConstructorTable = { 4, 3, JSMediaStreamConstructorTableValues, 0 };

COMPILE_ASSERT(1 == MediaStream::LIVE, MediaStreamEnumLIVEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == MediaStream::ENDED, MediaStreamEnumENDEDIsWrongUseDontCheckEnums);

class JSMediaStreamConstructor : public DOMConstructorObject {
private:
    JSMediaStreamConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSMediaStreamConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSMediaStreamConstructor* ptr = new (JSC::allocateCell<JSMediaStreamConstructor>(*exec->heap())) JSMediaStreamConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMediaStreamConstructor::s_info = { "MediaStreamConstructor", &DOMConstructorObject::s_info, &JSMediaStreamConstructorTable, 0 };

JSMediaStreamConstructor::JSMediaStreamConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaStreamConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMediaStreamPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMediaStreamConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaStreamConstructor, JSDOMWrapper>(exec, &JSMediaStreamConstructorTable, this, propertyName, slot);
}

bool JSMediaStreamConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaStreamConstructor, JSDOMWrapper>(exec, &JSMediaStreamConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamPrototypeTableValues[] =
{
    { "LIVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamLIVE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ENDED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamENDED), (intptr_t)0 THUNK_GENERATOR(0) },
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsMediaStreamPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsMediaStreamPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsMediaStreamPrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamPrototypeTable = { 17, 15, JSMediaStreamPrototypeTableValues, 0 };
const ClassInfo JSMediaStreamPrototype::s_info = { "MediaStreamPrototype", &JSC::JSNonFinalObject::s_info, &JSMediaStreamPrototypeTable, 0 };

JSObject* JSMediaStreamPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaStream>(exec, globalObject);
}

bool JSMediaStreamPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSMediaStreamPrototype, JSObject>(exec, &JSMediaStreamPrototypeTable, this, propertyName, slot);
}

bool JSMediaStreamPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSMediaStreamPrototype, JSObject>(exec, &JSMediaStreamPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSMediaStream::s_info = { "MediaStream", &JSDOMWrapper::s_info, &JSMediaStreamTable, 0 };

JSMediaStream::JSMediaStream(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaStream> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSMediaStream::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaStream::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaStreamPrototype::create(exec->globalData(), globalObject, JSMediaStreamPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSMediaStream::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSMediaStream, Base>(exec, &JSMediaStreamTable, this, propertyName, slot);
}

bool JSMediaStream::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSMediaStream, Base>(exec, &JSMediaStreamTable, this, propertyName, descriptor);
}

JSValue jsMediaStreamLabel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}


JSValue jsMediaStreamTracks(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->tracks()));
    return result;
}


JSValue jsMediaStreamReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    JSValue result = jsNumber(imp->readyState());
    return result;
}


JSValue jsMediaStreamOnended(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    if (EventListener* listener = imp->onended()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsMediaStreamConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStream* domObject = static_cast<JSMediaStream*>(asObject(slotBase));
    return JSMediaStream::getConstructor(exec, domObject->globalObject());
}

void JSMediaStream::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSMediaStream, Base>(exec, propertyName, value, &JSMediaStreamTable, this, slot);
}

void setJSMediaStreamOnended(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(thisObject);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    imp->setOnended(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSMediaStream::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaStream::s_info))
        return throwVMTypeError(exec);
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaStream::s_info);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaStream::s_info))
        return throwVMTypeError(exec);
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaStream::s_info);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaStream::s_info))
        return throwVMTypeError(exec);
    JSMediaStream* castedThis = static_cast<JSMediaStream*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaStream::s_info);
    MediaStream* imp = static_cast<MediaStream*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Event* event(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSMediaStream::visitChildren(SlotVisitor& visitor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(visitor);
    impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsMediaStreamLIVE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsMediaStreamENDED(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaStream* impl)
{
    return wrap<JSMediaStream>(exec, globalObject, impl);
}

MediaStream* toMediaStream(JSC::JSValue value)
{
    return value.inherits(&JSMediaStream::s_info) ? static_cast<JSMediaStream*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_STREAM)
