/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternals.h"

#include "ClientRect.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "Internals.h"
#include "JSClientRect.h"
#include "JSDOMBinding.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSInternals);

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInternalsPrototypeTableValues[] =
{
    { "elementRenderTreeAsText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionElementRenderTreeAsText), (intptr_t)1 THUNK_GENERATOR(0) },
    { "isPreloaded", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPreloaded), (intptr_t)2 THUNK_GENERATOR(0) },
    { "ensureShadowRoot", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEnsureShadowRoot), (intptr_t)1 THUNK_GENERATOR(0) },
    { "shadowRoot", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowRoot), (intptr_t)1 THUNK_GENERATOR(0) },
    { "includerFor", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIncluderFor), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeShadowRoot", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRemoveShadowRoot), (intptr_t)1 THUNK_GENERATOR(0) },
    { "shadowPseudoId", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowPseudoId), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createShadowContentElement", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCreateShadowContentElement), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getElementByIdInShadowRoot", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetElementByIdInShadowRoot), (intptr_t)2 THUNK_GENERATOR(0) },
    { "disableMemoryCache", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionDisableMemoryCache), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setInspectorResourcesDataSizeLimits", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits), (intptr_t)3 THUNK_GENERATOR(0) },
    { "boundingBox", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionBoundingBox), (intptr_t)1 THUNK_GENERATOR(0) },
    { "markerCountForNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerCountForNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "markerRangeForNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerRangeForNode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setForceCompositingMode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetForceCompositingMode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setZoomAnimatorScale", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetZoomAnimatorScale), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setPasswordEchoEnabled", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPasswordEchoEnabled), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setPasswordEchoDurationInSeconds", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPasswordEchoDurationInSeconds), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setScrollViewPosition", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetScrollViewPosition), (intptr_t)3 THUNK_GENERATOR(0) },
    { "wasLastChangeUserEdit", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWasLastChangeUserEdit), (intptr_t)1 THUNK_GENERATOR(0) },
    { "suggestedValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSuggestedValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setSuggestedValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetSuggestedValue), (intptr_t)2 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInternalsPrototypeTable = { 66, 63, JSInternalsPrototypeTableValues, 0 };
const ClassInfo JSInternalsPrototype::s_info = { "InternalsPrototype", &JSC::JSNonFinalObject::s_info, &JSInternalsPrototypeTable, 0 };

JSObject* JSInternalsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternals>(exec, globalObject);
}

bool JSInternalsPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSInternalsPrototypeTable, this, propertyName, slot);
}

bool JSInternalsPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInternalsPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSInternals::s_info = { "Internals", &JSDOMWrapper::s_info, 0, 0 };

JSInternals::JSInternals(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Internals> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSInternals::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternals::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalsPrototype::create(exec->globalData(), globalObject, JSInternalsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementRenderTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsString(exec, imp->elementRenderTreeAsText(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPreloaded(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->isPreloaded(document, url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnsureShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->ensureShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->shadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIncluderFor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->includerFor(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->removeShadowRoot(host, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowPseudoId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsString(exec, imp->shadowPseudoId(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateShadowContentElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createShadowContentElement(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetElementByIdInShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Node* shadowRoot(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& id(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementByIdInShadowRoot(shadowRoot, id, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDisableMemoryCache(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    bool disabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->disableMemoryCache(disabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int maximumResourcesContentSize(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int maximumSingleResourceContentSize(exec->argument(2).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setInspectorResourcesDataSizeLimits(document, maximumResourcesContentSize, maximumSingleResourceContentSize, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBoundingBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->boundingBox(element, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerCountForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->markerCountForNode(node, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerRangeForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->markerRangeForNode(node, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetForceCompositingMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool enabled(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setForceCompositingMode(document, enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetZoomAnimatorScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double scale(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setZoomAnimatorScale(document, scale, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPasswordEchoEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool enabled(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setPasswordEchoEnabled(document, enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPasswordEchoDurationInSeconds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double durationInSeconds(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setPasswordEchoDurationInSeconds(document, durationInSeconds, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetScrollViewPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(exec->argument(2).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setScrollViewPosition(document, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWasLastChangeUserEdit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* textField(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->wasLastChangeUserEdit(textField, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsString(exec, imp->suggestedValue(inputElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = static_cast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* imp = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setSuggestedValue(inputElement, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Internals* impl)
{
    return wrap<JSInternals>(exec, globalObject, impl);
}

Internals* toInternals(JSC::JSValue value)
{
    return value.inherits(&JSInternals::s_info) ? static_cast<JSInternals*>(asObject(value))->impl() : 0;
}

}
