/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBTransaction.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "IDBDatabase.h"
#include "IDBObjectStore.h"
#include "IDBTransaction.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSIDBDatabase.h"
#include "JSIDBObjectStore.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBTransaction);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBTransactionTableValues[] =
{
    { "mode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionMode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "db", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionDb), (intptr_t)0 THUNK_GENERATOR(0) },
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOnabort), (intptr_t)setJSIDBTransactionOnabort THUNK_GENERATOR(0) },
    { "oncomplete", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOncomplete), (intptr_t)setJSIDBTransactionOncomplete THUNK_GENERATOR(0) },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOnerror), (intptr_t)setJSIDBTransactionOnerror THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBTransactionTable = { 17, 15, JSIDBTransactionTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBTransactionConstructorTableValues[] =
{
    { "READ_ONLY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionREAD_ONLY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "READ_WRITE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionREAD_WRITE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "VERSION_CHANGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionVERSION_CHANGE), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBTransactionConstructorTable = { 8, 7, JSIDBTransactionConstructorTableValues, 0 };

COMPILE_ASSERT(0 == IDBTransaction::READ_ONLY, IDBTransactionEnumREAD_ONLYIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == IDBTransaction::READ_WRITE, IDBTransactionEnumREAD_WRITEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == IDBTransaction::VERSION_CHANGE, IDBTransactionEnumVERSION_CHANGEIsWrongUseDontCheckEnums);

class JSIDBTransactionConstructor : public DOMConstructorObject {
private:
    JSIDBTransactionConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSIDBTransactionConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSIDBTransactionConstructor* ptr = new (JSC::allocateCell<JSIDBTransactionConstructor>(*exec->heap())) JSIDBTransactionConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBTransactionConstructor::s_info = { "IDBTransactionConstructor", &DOMConstructorObject::s_info, &JSIDBTransactionConstructorTable, 0 };

JSIDBTransactionConstructor::JSIDBTransactionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBTransactionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSIDBTransactionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBTransactionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBTransactionConstructor, JSDOMWrapper>(exec, &JSIDBTransactionConstructorTable, this, propertyName, slot);
}

bool JSIDBTransactionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBTransactionConstructor, JSDOMWrapper>(exec, &JSIDBTransactionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBTransactionPrototypeTableValues[] =
{
    { "READ_ONLY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionREAD_ONLY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "READ_WRITE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionREAD_WRITE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "VERSION_CHANGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionVERSION_CHANGE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "objectStore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBTransactionPrototypeFunctionObjectStore), (intptr_t)1 THUNK_GENERATOR(0) },
    { "abort", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBTransactionPrototypeFunctionAbort), (intptr_t)0 THUNK_GENERATOR(0) },
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBTransactionPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBTransactionPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBTransactionPrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBTransactionPrototypeTable = { 16, 15, JSIDBTransactionPrototypeTableValues, 0 };
const ClassInfo JSIDBTransactionPrototype::s_info = { "IDBTransactionPrototype", &JSC::JSNonFinalObject::s_info, &JSIDBTransactionPrototypeTable, 0 };

JSObject* JSIDBTransactionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBTransaction>(exec, globalObject);
}

bool JSIDBTransactionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSIDBTransactionPrototype, JSObject>(exec, &JSIDBTransactionPrototypeTable, this, propertyName, slot);
}

bool JSIDBTransactionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSIDBTransactionPrototype, JSObject>(exec, &JSIDBTransactionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIDBTransaction::s_info = { "IDBTransaction", &JSDOMWrapper::s_info, &JSIDBTransactionTable, 0 };

JSIDBTransaction::JSIDBTransaction(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBTransaction> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSIDBTransaction::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBTransaction::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBTransactionPrototype::create(exec->globalData(), globalObject, JSIDBTransactionPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSIDBTransaction::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSIDBTransaction, Base>(exec, &JSIDBTransactionTable, this, propertyName, slot);
}

bool JSIDBTransaction::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSIDBTransaction, Base>(exec, &JSIDBTransactionTable, this, propertyName, descriptor);
}

JSValue jsIDBTransactionMode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    JSValue result = jsNumber(imp->mode());
    return result;
}


JSValue jsIDBTransactionDb(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->db()));
    return result;
}


JSValue jsIDBTransactionOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBTransactionOncomplete(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    if (EventListener* listener = imp->oncomplete()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBTransactionOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBTransactionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBTransaction* domObject = static_cast<JSIDBTransaction*>(asObject(slotBase));
    return JSIDBTransaction::getConstructor(exec, domObject->globalObject());
}

void JSIDBTransaction::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSIDBTransaction, Base>(exec, propertyName, value, &JSIDBTransactionTable, this, slot);
}

void setJSIDBTransactionOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(thisObject);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSIDBTransactionOncomplete(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(thisObject);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    imp->setOncomplete(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSIDBTransactionOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(thisObject);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSIDBTransaction::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBTransactionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBTransaction::s_info))
        return throwVMTypeError(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBTransaction::s_info);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objectStore(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionAbort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBTransaction::s_info))
        return throwVMTypeError(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBTransaction::s_info);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());

    imp->abort();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBTransaction::s_info))
        return throwVMTypeError(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBTransaction::s_info);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBTransaction::s_info))
        return throwVMTypeError(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBTransaction::s_info);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBTransaction::s_info))
        return throwVMTypeError(exec);
    JSIDBTransaction* castedThis = static_cast<JSIDBTransaction*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBTransaction::s_info);
    IDBTransaction* imp = static_cast<IDBTransaction*>(castedThis->impl());
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSIDBTransaction::visitChildren(SlotVisitor& visitor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(visitor);
    impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsIDBTransactionREAD_ONLY(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsIDBTransactionREAD_WRITE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsIDBTransactionVERSION_CHANGE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSIDBTransaction* jsIDBTransaction)
{
    if (jsIDBTransaction->hasCustomProperties())
        return true;
    if (jsIDBTransaction->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSIDBTransactionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBTransaction* jsIDBTransaction = static_cast<JSIDBTransaction*>(handle.get().asCell());
    if (jsIDBTransaction->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsIDBTransaction))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBTransactionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBTransaction* jsIDBTransaction = static_cast<JSIDBTransaction*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBTransaction->impl(), jsIDBTransaction);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBTransaction* impl)
{
    return wrap<JSIDBTransaction>(exec, globalObject, impl);
}

IDBTransaction* toIDBTransaction(JSC::JSValue value)
{
    return value.inherits(&JSIDBTransaction::s_info) ? static_cast<JSIDBTransaction*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
