/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBCursor.h"

#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBBindingUtilities.h"
#include "IDBCursor.h"
#include "IDBKey.h"
#include "IDBRequest.h"
#include "JSDOMBinding.h"
#include "JSIDBAny.h"
#include "JSIDBKey.h"
#include "JSIDBRequest.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBCursor);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBCursorTableValues[] =
{
    { "direction", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorDirection), (intptr_t)0 THUNK_GENERATOR(0) },
    { "key", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "primaryKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPrimaryKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "source", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorSource), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBCursorTable = { 16, 15, JSIDBCursorTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBCursorConstructorTableValues[] =
{
    { "NEXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorNEXT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NEXT_NO_DUPLICATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorNEXT_NO_DUPLICATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "PREV", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPREV), (intptr_t)0 THUNK_GENERATOR(0) },
    { "PREV_NO_DUPLICATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPREV_NO_DUPLICATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBCursorConstructorTable = { 10, 7, JSIDBCursorConstructorTableValues, 0 };

COMPILE_ASSERT(0 == IDBCursor::NEXT, IDBCursorEnumNEXTIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == IDBCursor::NEXT_NO_DUPLICATE, IDBCursorEnumNEXT_NO_DUPLICATEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == IDBCursor::PREV, IDBCursorEnumPREVIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == IDBCursor::PREV_NO_DUPLICATE, IDBCursorEnumPREV_NO_DUPLICATEIsWrongUseDontCheckEnums);

class JSIDBCursorConstructor : public DOMConstructorObject {
private:
    JSIDBCursorConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSIDBCursorConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSIDBCursorConstructor* ptr = new (JSC::allocateCell<JSIDBCursorConstructor>(*exec->heap())) JSIDBCursorConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBCursorConstructor::s_info = { "IDBCursorConstructor", &DOMConstructorObject::s_info, &JSIDBCursorConstructorTable, 0 };

JSIDBCursorConstructor::JSIDBCursorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBCursorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSIDBCursorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBCursorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBCursorConstructor, JSDOMWrapper>(exec, &JSIDBCursorConstructorTable, this, propertyName, slot);
}

bool JSIDBCursorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBCursorConstructor, JSDOMWrapper>(exec, &JSIDBCursorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBCursorPrototypeTableValues[] =
{
    { "NEXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorNEXT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NEXT_NO_DUPLICATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorNEXT_NO_DUPLICATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "PREV", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPREV), (intptr_t)0 THUNK_GENERATOR(0) },
    { "PREV_NO_DUPLICATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPREV_NO_DUPLICATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "update", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionUpdate), (intptr_t)1 THUNK_GENERATOR(0) },
    { "continue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionContinue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "delete", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionDelete), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBCursorPrototypeTable = { 18, 15, JSIDBCursorPrototypeTableValues, 0 };
const ClassInfo JSIDBCursorPrototype::s_info = { "IDBCursorPrototype", &JSC::JSNonFinalObject::s_info, &JSIDBCursorPrototypeTable, 0 };

JSObject* JSIDBCursorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBCursor>(exec, globalObject);
}

bool JSIDBCursorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSIDBCursorPrototype, JSObject>(exec, &JSIDBCursorPrototypeTable, this, propertyName, slot);
}

bool JSIDBCursorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSIDBCursorPrototype, JSObject>(exec, &JSIDBCursorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIDBCursor::s_info = { "IDBCursor", &JSDOMWrapper::s_info, &JSIDBCursorTable, 0 };

JSIDBCursor::JSIDBCursor(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBCursor> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSIDBCursor::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBCursor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBCursorPrototype::create(exec->globalData(), globalObject, JSIDBCursorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSIDBCursor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSIDBCursor, Base>(exec, &JSIDBCursorTable, this, propertyName, slot);
}

bool JSIDBCursor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSIDBCursor, Base>(exec, &JSIDBCursorTable, this, propertyName, descriptor);
}

JSValue jsIDBCursorDirection(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    JSValue result = jsNumber(imp->direction());
    return result;
}


JSValue jsIDBCursorKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->key()));
    return result;
}


JSValue jsIDBCursorPrimaryKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->primaryKey()));
    return result;
}


JSValue jsIDBCursorSource(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->source()));
    return result;
}


JSValue jsIDBCursorConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBCursor* domObject = static_cast<JSIDBCursor*>(asObject(slotBase));
    return JSIDBCursor::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBCursor::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBCursorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionUpdate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBCursor::s_info))
        return throwVMTypeError(exec);
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBCursor::s_info);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    RefPtr<SerializedScriptValue> value(SerializedScriptValue::create(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->update(scriptContext, value, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionContinue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBCursor::s_info))
        return throwVMTypeError(exec);
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBCursor::s_info);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    ExceptionCode ec = 0;

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        imp->continueFunction(ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    RefPtr<IDBKey> key(createIDBKeyFromValue(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->continueFunction(key, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionDelete(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBCursor::s_info))
        return throwVMTypeError(exec);
    JSIDBCursor* castedThis = static_cast<JSIDBCursor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBCursor::s_info);
    IDBCursor* imp = static_cast<IDBCursor*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->deleteFunction(scriptContext, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

// Constant getters

JSValue jsIDBCursorNEXT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsIDBCursorNEXT_NO_DUPLICATE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsIDBCursorPREV(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsIDBCursorPREV_NO_DUPLICATE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBCursor* impl)
{
    return wrap<JSIDBCursor>(exec, globalObject, impl);
}

IDBCursor* toIDBCursor(JSC::JSValue value)
{
    return value.inherits(&JSIDBCursor::s_info) ? static_cast<JSIDBCursor*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
