/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOutputElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLOutputElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOutputElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLOutputElementTableValues[] =
{
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementHtmlFor), (intptr_t)setJSHTMLOutputElementHtmlFor THUNK_GENERATOR(0) },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementForm), (intptr_t)0 THUNK_GENERATOR(0) },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementName), (intptr_t)setJSHTMLOutputElementName THUNK_GENERATOR(0) },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementType), (intptr_t)0 THUNK_GENERATOR(0) },
    { "defaultValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementDefaultValue), (intptr_t)setJSHTMLOutputElementDefaultValue THUNK_GENERATOR(0) },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValue), (intptr_t)setJSHTMLOutputElementValue THUNK_GENERATOR(0) },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementWillValidate), (intptr_t)0 THUNK_GENERATOR(0) },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidationMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementLabels), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLOutputElementTable = { 34, 31, JSHTMLOutputElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLOutputElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLOutputElementConstructorTable = { 1, 0, JSHTMLOutputElementConstructorTableValues, 0 };
class JSHTMLOutputElementConstructor : public DOMConstructorObject {
private:
    JSHTMLOutputElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLOutputElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLOutputElementConstructor* ptr = new (JSC::allocateCell<JSHTMLOutputElementConstructor>(*exec->heap())) JSHTMLOutputElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLOutputElementConstructor::s_info = { "HTMLOutputElementConstructor", &DOMConstructorObject::s_info, &JSHTMLOutputElementConstructorTable, 0 };

JSHTMLOutputElementConstructor::JSHTMLOutputElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLOutputElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOutputElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLOutputElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOutputElementConstructor, JSDOMWrapper>(exec, &JSHTMLOutputElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLOutputElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLOutputElementConstructor, JSDOMWrapper>(exec, &JSHTMLOutputElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLOutputElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLOutputElementPrototypeFunctionCheckValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setCustomValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLOutputElementPrototypeFunctionSetCustomValidity), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLOutputElementPrototypeTable = { 4, 3, JSHTMLOutputElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLOutputElementPrototype::s_info = { "HTMLOutputElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLOutputElementPrototypeTable, 0 };

JSObject* JSHTMLOutputElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOutputElement>(exec, globalObject);
}

bool JSHTMLOutputElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLOutputElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLOutputElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLOutputElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLOutputElement::s_info = { "HTMLOutputElement", &JSHTMLElement::s_info, &JSHTMLOutputElementTable, 0 };

JSHTMLOutputElement::JSHTMLOutputElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLOutputElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLOutputElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLOutputElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLOutputElementPrototype::create(exec->globalData(), globalObject, JSHTMLOutputElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOutputElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLOutputElement, Base>(exec, &JSHTMLOutputElementTable, this, propertyName, slot);
}

bool JSHTMLOutputElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLOutputElement, Base>(exec, &JSHTMLOutputElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLOutputElementHtmlFor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    return castedThis->htmlFor(exec);
}


JSValue jsHTMLOutputElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}


JSValue jsHTMLOutputElementName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLOutputElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}


JSValue jsHTMLOutputElementDefaultValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->defaultValue());
    return result;
}


JSValue jsHTMLOutputElementValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->value());
    return result;
}


JSValue jsHTMLOutputElementWillValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->willValidate());
    return result;
}


JSValue jsHTMLOutputElementValidity(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->validity()));
    return result;
}


JSValue jsHTMLOutputElementValidationMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->validationMessage());
    return result;
}


JSValue jsHTMLOutputElementLabels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->labels()));
    return result;
}


JSValue jsHTMLOutputElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLOutputElement* domObject = static_cast<JSHTMLOutputElement*>(asObject(slotBase));
    return JSHTMLOutputElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLOutputElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLOutputElement, Base>(exec, propertyName, value, &JSHTMLOutputElementTable, this, slot);
}

void setJSHTMLOutputElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLOutputElement*>(thisObject)->setHtmlFor(exec, value);
}


void setJSHTMLOutputElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLOutputElementDefaultValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    imp->setDefaultValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLOutputElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLOutputElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOutputElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLOutputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLOutputElement::s_info);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());


    JSC::JSValue result = jsBoolean(imp->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLOutputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLOutputElement* castedThis = static_cast<JSHTMLOutputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLOutputElement::s_info);
    HTMLOutputElement* imp = static_cast<HTMLOutputElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
