/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLModElement.h"

#include "HTMLModElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLModElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLModElementTableValues[] =
{
    { "cite", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLModElementCite), (intptr_t)setJSHTMLModElementCite THUNK_GENERATOR(0) },
    { "dateTime", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLModElementDateTime), (intptr_t)setJSHTMLModElementDateTime THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLModElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLModElementTable = { 10, 7, JSHTMLModElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLModElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLModElementConstructorTable = { 1, 0, JSHTMLModElementConstructorTableValues, 0 };
class JSHTMLModElementConstructor : public DOMConstructorObject {
private:
    JSHTMLModElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLModElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLModElementConstructor* ptr = new (JSC::allocateCell<JSHTMLModElementConstructor>(*exec->heap())) JSHTMLModElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLModElementConstructor::s_info = { "HTMLModElementConstructor", &DOMConstructorObject::s_info, &JSHTMLModElementConstructorTable, 0 };

JSHTMLModElementConstructor::JSHTMLModElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLModElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLModElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLModElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLModElementConstructor, JSDOMWrapper>(exec, &JSHTMLModElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLModElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLModElementConstructor, JSDOMWrapper>(exec, &JSHTMLModElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLModElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLModElementPrototypeTable = { 1, 0, JSHTMLModElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLModElementPrototype::s_info = { "HTMLModElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLModElementPrototypeTable, 0 };

JSObject* JSHTMLModElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLModElement>(exec, globalObject);
}

const ClassInfo JSHTMLModElement::s_info = { "HTMLModElement", &JSHTMLElement::s_info, &JSHTMLModElementTable, 0 };

JSHTMLModElement::JSHTMLModElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLModElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLModElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLModElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLModElementPrototype::create(exec->globalData(), globalObject, JSHTMLModElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLModElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLModElement, Base>(exec, &JSHTMLModElementTable, this, propertyName, slot);
}

bool JSHTMLModElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLModElement, Base>(exec, &JSHTMLModElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLModElementCite(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLModElement* castedThis = static_cast<JSHTMLModElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLModElement* imp = static_cast<HTMLModElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::citeAttr));
    return result;
}


JSValue jsHTMLModElementDateTime(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLModElement* castedThis = static_cast<JSHTMLModElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLModElement* imp = static_cast<HTMLModElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::datetimeAttr));
    return result;
}


JSValue jsHTMLModElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLModElement* domObject = static_cast<JSHTMLModElement*>(asObject(slotBase));
    return JSHTMLModElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLModElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLModElement, Base>(exec, propertyName, value, &JSHTMLModElementTable, this, slot);
}

void setJSHTMLModElementCite(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLModElement* castedThis = static_cast<JSHTMLModElement*>(thisObject);
    HTMLModElement* imp = static_cast<HTMLModElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::citeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLModElementDateTime(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLModElement* castedThis = static_cast<JSHTMLModElement*>(thisObject);
    HTMLModElement* imp = static_cast<HTMLModElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::datetimeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLModElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLModElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
