/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHtmlElement.h"

#include "HTMLHtmlElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHtmlElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHtmlElementTableValues[] =
{
    { "version", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementVersion), (intptr_t)setJSHTMLHtmlElementVersion THUNK_GENERATOR(0) },
    { "manifest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementManifest), (intptr_t)setJSHTMLHtmlElementManifest THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementTable = { 9, 7, JSHTMLHtmlElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHtmlElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementConstructorTable = { 1, 0, JSHTMLHtmlElementConstructorTableValues, 0 };
class JSHTMLHtmlElementConstructor : public DOMConstructorObject {
private:
    JSHTMLHtmlElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLHtmlElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLHtmlElementConstructor* ptr = new (JSC::allocateCell<JSHTMLHtmlElementConstructor>(*exec->heap())) JSHTMLHtmlElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLHtmlElementConstructor::s_info = { "HTMLHtmlElementConstructor", &DOMConstructorObject::s_info, &JSHTMLHtmlElementConstructorTable, 0 };

JSHTMLHtmlElementConstructor::JSHTMLHtmlElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLHtmlElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLHtmlElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLHtmlElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElementConstructor, JSDOMWrapper>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLHtmlElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHtmlElementConstructor, JSDOMWrapper>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHtmlElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementPrototypeTable = { 1, 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLHtmlElementPrototype::s_info = { "HTMLHtmlElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLHtmlElementPrototypeTable, 0 };

JSObject* JSHTMLHtmlElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHtmlElement>(exec, globalObject);
}

const ClassInfo JSHTMLHtmlElement::s_info = { "HTMLHtmlElement", &JSHTMLElement::s_info, &JSHTMLHtmlElementTable, 0 };

JSHTMLHtmlElement::JSHTMLHtmlElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHtmlElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLHtmlElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLHtmlElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLHtmlElementPrototype::create(exec->globalData(), globalObject, JSHTMLHtmlElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHtmlElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, slot);
}

bool JSHTMLHtmlElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLHtmlElementVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHtmlElement* castedThis = static_cast<JSHTMLHtmlElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::versionAttr));
    return result;
}


JSValue jsHTMLHtmlElementManifest(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHtmlElement* castedThis = static_cast<JSHTMLHtmlElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::manifestAttr));
    return result;
}


JSValue jsHTMLHtmlElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHtmlElement* domObject = static_cast<JSHTMLHtmlElement*>(asObject(slotBase));
    return JSHTMLHtmlElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLHtmlElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLHtmlElement, Base>(exec, propertyName, value, &JSHTMLHtmlElementTable, this, slot);
}

void setJSHTMLHtmlElementVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLHtmlElement* castedThis = static_cast<JSHTMLHtmlElement*>(thisObject);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::versionAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLHtmlElementManifest(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLHtmlElement* castedThis = static_cast<JSHTMLHtmlElement*>(thisObject);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::manifestAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLHtmlElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHtmlElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
