/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameSetElement.h"

#include "EventListener.h"
#include "HTMLFrameSetElement.h"
#include "HTMLNames.h"
#include "JSEventListener.h"
#include "KURL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLFrameSetElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLFrameSetElementTableValues[] =
{
    { "cols", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementCols), (intptr_t)setJSHTMLFrameSetElementCols THUNK_GENERATOR(0) },
    { "rows", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementRows), (intptr_t)setJSHTMLFrameSetElementRows THUNK_GENERATOR(0) },
    { "onbeforeunload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnbeforeunload), (intptr_t)setJSHTMLFrameSetElementOnbeforeunload THUNK_GENERATOR(0) },
    { "onhashchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnhashchange), (intptr_t)setJSHTMLFrameSetElementOnhashchange THUNK_GENERATOR(0) },
    { "onmessage", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnmessage), (intptr_t)setJSHTMLFrameSetElementOnmessage THUNK_GENERATOR(0) },
    { "onoffline", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnoffline), (intptr_t)setJSHTMLFrameSetElementOnoffline THUNK_GENERATOR(0) },
    { "ononline", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnonline), (intptr_t)setJSHTMLFrameSetElementOnonline THUNK_GENERATOR(0) },
    { "onpopstate", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpopstate), (intptr_t)setJSHTMLFrameSetElementOnpopstate THUNK_GENERATOR(0) },
    { "onresize", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnresize), (intptr_t)setJSHTMLFrameSetElementOnresize THUNK_GENERATOR(0) },
    { "onstorage", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnstorage), (intptr_t)setJSHTMLFrameSetElementOnstorage THUNK_GENERATOR(0) },
    { "onunload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnunload), (intptr_t)setJSHTMLFrameSetElementOnunload THUNK_GENERATOR(0) },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnorientationchange), (intptr_t)setJSHTMLFrameSetElementOnorientationchange THUNK_GENERATOR(0) },
#endif
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnblur), (intptr_t)setJSHTMLFrameSetElementOnblur THUNK_GENERATOR(0) },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnerror), (intptr_t)setJSHTMLFrameSetElementOnerror THUNK_GENERATOR(0) },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocus), (intptr_t)setJSHTMLFrameSetElementOnfocus THUNK_GENERATOR(0) },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnload), (intptr_t)setJSHTMLFrameSetElementOnload THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementTable = { 64, 63, JSHTMLFrameSetElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLFrameSetElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementConstructorTable = { 1, 0, JSHTMLFrameSetElementConstructorTableValues, 0 };
class JSHTMLFrameSetElementConstructor : public DOMConstructorObject {
private:
    JSHTMLFrameSetElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLFrameSetElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLFrameSetElementConstructor* ptr = new (JSC::allocateCell<JSHTMLFrameSetElementConstructor>(*exec->heap())) JSHTMLFrameSetElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLFrameSetElementConstructor::s_info = { "HTMLFrameSetElementConstructor", &DOMConstructorObject::s_info, &JSHTMLFrameSetElementConstructorTable, 0 };

JSHTMLFrameSetElementConstructor::JSHTMLFrameSetElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLFrameSetElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLFrameSetElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLFrameSetElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameSetElementConstructor, JSDOMWrapper>(exec, &JSHTMLFrameSetElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLFrameSetElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFrameSetElementConstructor, JSDOMWrapper>(exec, &JSHTMLFrameSetElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLFrameSetElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementPrototypeTable = { 1, 0, JSHTMLFrameSetElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLFrameSetElementPrototype::s_info = { "HTMLFrameSetElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLFrameSetElementPrototypeTable, 0 };

JSObject* JSHTMLFrameSetElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFrameSetElement>(exec, globalObject);
}

const ClassInfo JSHTMLFrameSetElement::s_info = { "HTMLFrameSetElement", &JSHTMLElement::s_info, &JSHTMLFrameSetElementTable, 0 };

JSHTMLFrameSetElement::JSHTMLFrameSetElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFrameSetElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLFrameSetElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLFrameSetElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLFrameSetElementPrototype::create(exec->globalData(), globalObject, JSHTMLFrameSetElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLFrameSetElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (canGetItemsForName(exec, static_cast<HTMLFrameSetElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLFrameSetElement, Base>(exec, &JSHTMLFrameSetElementTable, this, propertyName, slot);
}

bool JSHTMLFrameSetElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (canGetItemsForName(exec, static_cast<HTMLFrameSetElement*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLFrameSetElement, Base>(exec, &JSHTMLFrameSetElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLFrameSetElementCols(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::colsAttr));
    return result;
}


JSValue jsHTMLFrameSetElementRows(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::rowsAttr));
    return result;
}


JSValue jsHTMLFrameSetElementOnbeforeunload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforeunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnhashchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onhashchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnmessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnoffline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onoffline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnonline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->ononline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnpopstate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onpopstate()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnresize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnstorage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onstorage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnunload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


#if ENABLE(ORIENTATION_EVENTS)
JSValue jsHTMLFrameSetElementOnorientationchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onorientationchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

JSValue jsHTMLFrameSetElementOnblur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnfocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLFrameSetElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLFrameSetElement* domObject = static_cast<JSHTMLFrameSetElement*>(asObject(slotBase));
    return JSHTMLFrameSetElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLFrameSetElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLFrameSetElement, Base>(exec, propertyName, value, &JSHTMLFrameSetElementTable, this, slot);
}

void setJSHTMLFrameSetElementCols(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::colsAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameSetElementRows(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::rowsAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameSetElementOnbeforeunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnbeforeunload(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnhashchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnhashchange(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnmessage(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnoffline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnoffline(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnonline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnonline(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnpopstate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnpopstate(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnresize(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnstorage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnstorage(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnunload(createJSAttributeEventListener(exec, value, globalObject));
}


#if ENABLE(ORIENTATION_EVENTS)
void setJSHTMLFrameSetElementOnorientationchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnorientationchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

void setJSHTMLFrameSetElementOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnblur(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnfocus(createJSAttributeEventListener(exec, value, globalObject));
}


void setJSHTMLFrameSetElementOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(thisObject);
    JSDOMGlobalObject* globalObject = castedThis->globalObject();
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, globalObject));
}


JSValue JSHTMLFrameSetElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameSetElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
