/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBaseElement.h"

#include "HTMLBaseElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBaseElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLBaseElementTableValues[] =
{
    { "href", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementHref), (intptr_t)setJSHTMLBaseElementHref THUNK_GENERATOR(0) },
    { "target", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementTarget), (intptr_t)setJSHTMLBaseElementTarget THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementTable = { 8, 7, JSHTMLBaseElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLBaseElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementConstructorTable = { 1, 0, JSHTMLBaseElementConstructorTableValues, 0 };
class JSHTMLBaseElementConstructor : public DOMConstructorObject {
private:
    JSHTMLBaseElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLBaseElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLBaseElementConstructor* ptr = new (JSC::allocateCell<JSHTMLBaseElementConstructor>(*exec->heap())) JSHTMLBaseElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLBaseElementConstructor::s_info = { "HTMLBaseElementConstructor", &DOMConstructorObject::s_info, &JSHTMLBaseElementConstructorTable, 0 };

JSHTMLBaseElementConstructor::JSHTMLBaseElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLBaseElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLBaseElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLBaseElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseElementConstructor, JSDOMWrapper>(exec, &JSHTMLBaseElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLBaseElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBaseElementConstructor, JSDOMWrapper>(exec, &JSHTMLBaseElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLBaseElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementPrototypeTable = { 1, 0, JSHTMLBaseElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLBaseElementPrototype::s_info = { "HTMLBaseElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLBaseElementPrototypeTable, 0 };

JSObject* JSHTMLBaseElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBaseElement>(exec, globalObject);
}

const ClassInfo JSHTMLBaseElement::s_info = { "HTMLBaseElement", &JSHTMLElement::s_info, &JSHTMLBaseElementTable, 0 };

JSHTMLBaseElement::JSHTMLBaseElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLBaseElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLBaseElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLBaseElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLBaseElementPrototype::create(exec->globalData(), globalObject, JSHTMLBaseElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLBaseElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLBaseElement, Base>(exec, &JSHTMLBaseElementTable, this, propertyName, slot);
}

bool JSHTMLBaseElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLBaseElement, Base>(exec, &JSHTMLBaseElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLBaseElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}


JSValue jsHTMLBaseElementTarget(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}


JSValue jsHTMLBaseElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLBaseElement* domObject = static_cast<JSHTMLBaseElement*>(asObject(slotBase));
    return JSHTMLBaseElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLBaseElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLBaseElement, Base>(exec, propertyName, value, &JSHTMLBaseElementTable, this, slot);
}

void setJSHTMLBaseElementHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(thisObject);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::hrefAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLBaseElementTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(thisObject);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::targetAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLBaseElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBaseElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
