/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeoposition.h"

#include "Coordinates.h"
#include "Geoposition.h"
#include "JSCoordinates.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSGeoposition);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSGeopositionTableValues[] =
{
    { "coords", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionCoords), (intptr_t)0 THUNK_GENERATOR(0) },
    { "timestamp", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionTimestamp), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSGeopositionTable = { 4, 3, JSGeopositionTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSGeopositionPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSGeopositionPrototypeTable = { 1, 0, JSGeopositionPrototypeTableValues, 0 };
const ClassInfo JSGeopositionPrototype::s_info = { "GeopositionPrototype", &JSC::JSNonFinalObject::s_info, &JSGeopositionPrototypeTable, 0 };

JSObject* JSGeopositionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeoposition>(exec, globalObject);
}

const ClassInfo JSGeoposition::s_info = { "Geoposition", &JSDOMWrapper::s_info, &JSGeopositionTable, 0 };

JSGeoposition::JSGeoposition(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Geoposition> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSGeoposition::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSGeoposition::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSGeopositionPrototype::create(exec->globalData(), globalObject, JSGeopositionPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSGeoposition::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSGeoposition, Base>(exec, &JSGeopositionTable, this, propertyName, slot);
}

bool JSGeoposition::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSGeoposition, Base>(exec, &JSGeopositionTable, this, propertyName, descriptor);
}

JSValue jsGeopositionCoords(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSGeoposition* castedThis = static_cast<JSGeoposition*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Geoposition* imp = static_cast<Geoposition*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->coords()));
    return result;
}


JSValue jsGeopositionTimestamp(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSGeoposition* castedThis = static_cast<JSGeoposition*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Geoposition* imp = static_cast<Geoposition*>(castedThis->impl());
    JSValue result = jsNumber(imp->timestamp());
    return result;
}


JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Geoposition* impl)
{
    return wrap<JSGeoposition>(exec, globalObject, impl);
}

Geoposition* toGeoposition(JSC::JSValue value)
{
    return value.inherits(&JSGeoposition::s_info) ? static_cast<JSGeoposition*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
