/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSErrorEvent.h"

#include "ErrorEvent.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSErrorEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSErrorEventTableValues[] =
{
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "filename", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventFilename), (intptr_t)0 THUNK_GENERATOR(0) },
    { "lineno", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventLineno), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSErrorEventTable = { 9, 7, JSErrorEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSErrorEventConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSErrorEventConstructorTable = { 1, 0, JSErrorEventConstructorTableValues, 0 };
class JSErrorEventConstructor : public DOMConstructorObject {
private:
    JSErrorEventConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSErrorEventConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSErrorEventConstructor* ptr = new (JSC::allocateCell<JSErrorEventConstructor>(*exec->heap())) JSErrorEventConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSErrorEventConstructor::s_info = { "ErrorEventConstructor", &DOMConstructorObject::s_info, &JSErrorEventConstructorTable, 0 };

JSErrorEventConstructor::JSErrorEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSErrorEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSErrorEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSErrorEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSErrorEventConstructor, JSDOMWrapper>(exec, &JSErrorEventConstructorTable, this, propertyName, slot);
}

bool JSErrorEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSErrorEventConstructor, JSDOMWrapper>(exec, &JSErrorEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSErrorEventPrototypeTableValues[] =
{
    { "initErrorEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsErrorEventPrototypeFunctionInitErrorEvent), (intptr_t)6 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSErrorEventPrototypeTable = { 2, 1, JSErrorEventPrototypeTableValues, 0 };
static const HashTable* getJSErrorEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSErrorEventPrototypeTable);
}

const ClassInfo JSErrorEventPrototype::s_info = { "ErrorEventPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSErrorEventPrototypeTable };

JSObject* JSErrorEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSErrorEvent>(exec, globalObject);
}

bool JSErrorEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSErrorEventPrototypeTable(exec), this, propertyName, slot);
}

bool JSErrorEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSErrorEventPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSErrorEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSErrorEventTable);
}

const ClassInfo JSErrorEvent::s_info = { "ErrorEvent", &JSEvent::s_info, 0, getJSErrorEventTable };

JSErrorEvent::JSErrorEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ErrorEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSErrorEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSErrorEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSErrorEventPrototype::create(exec->globalData(), globalObject, JSErrorEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSErrorEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), this, propertyName, slot);
}

bool JSErrorEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), this, propertyName, descriptor);
}

JSValue jsErrorEventMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}


JSValue jsErrorEventFilename(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->filename());
    return result;
}


JSValue jsErrorEventLineno(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsNumber(imp->lineno());
    return result;
}


JSValue jsErrorEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSErrorEvent* domObject = static_cast<JSErrorEvent*>(asObject(slotBase));
    return JSErrorEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSErrorEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSErrorEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsErrorEventPrototypeFunctionInitErrorEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSErrorEvent::s_info))
        return throwVMTypeError(exec);
    JSErrorEvent* castedThis = static_cast<JSErrorEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSErrorEvent::s_info);
    ErrorEvent* imp = static_cast<ErrorEvent*>(castedThis->impl());
    const String& typeArg(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& messageArg(ustringToString(exec->argument(3).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& filenameArg(ustringToString(exec->argument(4).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned linenoArg(exec->argument(5).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initErrorEvent(typeArg, canBubbleArg, cancelableArg, messageArg, filenameArg, linenoArg);
    return JSValue::encode(jsUndefined());
}


}
