/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEntity.h"

#include "Entity.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEntity);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntityTableValues[] =
{
    { "publicId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntityPublicId), (intptr_t)0 THUNK_GENERATOR(0) },
    { "systemId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntitySystemId), (intptr_t)0 THUNK_GENERATOR(0) },
    { "notationName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntityNotationName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntityConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntityTable = { 10, 7, JSEntityTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntityConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntityConstructorTable = { 1, 0, JSEntityConstructorTableValues, 0 };
class JSEntityConstructor : public DOMConstructorObject {
private:
    JSEntityConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSEntityConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSEntityConstructor* ptr = new (JSC::allocateCell<JSEntityConstructor>(*exec->heap())) JSEntityConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSEntityConstructor::s_info = { "EntityConstructor", &DOMConstructorObject::s_info, &JSEntityConstructorTable, 0 };

JSEntityConstructor::JSEntityConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSEntityConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSEntityPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSEntityConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityConstructor, JSDOMWrapper>(exec, &JSEntityConstructorTable, this, propertyName, slot);
}

bool JSEntityConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntityConstructor, JSDOMWrapper>(exec, &JSEntityConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSEntityPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSEntityPrototypeTable = { 1, 0, JSEntityPrototypeTableValues, 0 };
const ClassInfo JSEntityPrototype::s_info = { "EntityPrototype", &JSC::JSNonFinalObject::s_info, &JSEntityPrototypeTable, 0 };

JSObject* JSEntityPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntity>(exec, globalObject);
}

const ClassInfo JSEntity::s_info = { "Entity", &JSNode::s_info, &JSEntityTable, 0 };

JSEntity::JSEntity(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Entity> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSEntity::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntity::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntityPrototype::create(exec->globalData(), globalObject, JSEntityPrototype::createStructure(exec->globalData(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSEntity::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, slot);
}

bool JSEntity::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, descriptor);
}

JSValue jsEntityPublicId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->publicId());
    return result;
}


JSValue jsEntitySystemId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->systemId());
    return result;
}


JSValue jsEntityNotationName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->notationName());
    return result;
}


JSValue jsEntityConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntity* domObject = static_cast<JSEntity*>(asObject(slotBase));
    return JSEntity::getConstructor(exec, domObject->globalObject());
}

JSValue JSEntity::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEntityConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
