/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDataView.h"

#include "DataView.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDataView);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataViewTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataViewConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataViewTable = { 2, 1, JSDataViewTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataViewConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataViewConstructorTable = { 1, 0, JSDataViewConstructorTableValues, 0 };
const ClassInfo JSDataViewConstructor::s_info = { "DataViewConstructor", &DOMConstructorObject::s_info, &JSDataViewConstructorTable, 0 };

JSDataViewConstructor::JSDataViewConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDataViewConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDataViewPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDataViewConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDataViewConstructor, JSDOMWrapper>(exec, &JSDataViewConstructorTable, this, propertyName, slot);
}

bool JSDataViewConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDataViewConstructor, JSDOMWrapper>(exec, &JSDataViewConstructorTable, this, propertyName, descriptor);
}

ConstructType JSDataViewConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSDataView;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDataViewPrototypeTableValues[] =
{
    { "getInt8", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetInt8), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getUint8", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetUint8), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getInt16", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetInt16), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getUint16", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetUint16), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getInt32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetInt32), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getUint32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetUint32), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getFloat32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetFloat32), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getFloat64", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionGetFloat64), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setInt8", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetInt8), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setUint8", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetUint8), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setInt16", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetInt16), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setUint16", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetUint16), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setInt32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetInt32), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setUint32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetUint32), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setFloat32", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetFloat32), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setFloat64", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDataViewPrototypeFunctionSetFloat64), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDataViewPrototypeTable = { 37, 31, JSDataViewPrototypeTableValues, 0 };
static const HashTable* getJSDataViewPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDataViewPrototypeTable);
}

const ClassInfo JSDataViewPrototype::s_info = { "DataViewPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSDataViewPrototypeTable };

JSObject* JSDataViewPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataView>(exec, globalObject);
}

bool JSDataViewPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDataViewPrototypeTable(exec), this, propertyName, slot);
}

bool JSDataViewPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDataViewPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSDataViewTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDataViewTable);
}

const ClassInfo JSDataView::s_info = { "DataView", &JSArrayBufferView::s_info, 0, getJSDataViewTable };

JSDataView::JSDataView(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DataView> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

void JSDataView::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDataView::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDataViewPrototype::create(exec->globalData(), globalObject, JSDataViewPrototype::createStructure(exec->globalData(), globalObject, JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSDataView::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSDataView, Base>(exec, getJSDataViewTable(exec), this, propertyName, slot);
}

bool JSDataView::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSDataView, Base>(exec, getJSDataViewTable(exec), this, propertyName, descriptor);
}

JSValue jsDataViewConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataView* domObject = static_cast<JSDataView*>(asObject(slotBase));
    return JSDataView::getConstructor(exec, domObject->globalObject());
}

JSValue JSDataView::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataViewConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetInt8(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->getInt8(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetUint8(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->getUint8(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetInt16(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(imp->getInt16(byteOffset, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool littleEndian(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->getInt16(byteOffset, littleEndian, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetUint16(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(imp->getUint16(byteOffset, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool littleEndian(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->getUint16(byteOffset, littleEndian, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetInt32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(imp->getInt32(byteOffset, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool littleEndian(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->getInt32(byteOffset, littleEndian, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetUint32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(imp->getUint32(byteOffset, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool littleEndian(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsNumber(imp->getUint32(byteOffset, littleEndian, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetFloat32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->getFloat32(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionGetFloat64(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->getFloat64(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetInt8(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->setInt8(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetUint8(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    return JSValue::encode(castedThis->setUint8(exec));
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetInt16(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    short value(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setInt16(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setInt16(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetUint16(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned short value(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setUint16(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setUint16(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetInt32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int value(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setInt32(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setInt32(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetUint32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned value(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setUint32(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setUint32(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetFloat32(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float value(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setFloat32(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setFloat32(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataViewPrototypeFunctionSetFloat64(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataView::s_info))
        return throwVMTypeError(exec);
    JSDataView* castedThis = static_cast<JSDataView*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataView::s_info);
    DataView* imp = static_cast<DataView*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    unsigned byteOffset(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double value(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        imp->setFloat64(byteOffset, value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    bool littleEndian(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setFloat64(byteOffset, value, littleEndian, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
