/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMSettableTokenList.h"

#include "DOMSettableTokenList.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMSettableTokenList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMSettableTokenListTableValues[] =
{
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSettableTokenListValue), (intptr_t)setJSDOMSettableTokenListValue THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSettableTokenListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMSettableTokenListTable = { 4, 3, JSDOMSettableTokenListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMSettableTokenListConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMSettableTokenListConstructorTable = { 1, 0, JSDOMSettableTokenListConstructorTableValues, 0 };
class JSDOMSettableTokenListConstructor : public DOMConstructorObject {
private:
    JSDOMSettableTokenListConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDOMSettableTokenListConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDOMSettableTokenListConstructor* ptr = new (JSC::allocateCell<JSDOMSettableTokenListConstructor>(*exec->heap())) JSDOMSettableTokenListConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMSettableTokenListConstructor::s_info = { "DOMSettableTokenListConstructor", &DOMConstructorObject::s_info, &JSDOMSettableTokenListConstructorTable, 0 };

JSDOMSettableTokenListConstructor::JSDOMSettableTokenListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMSettableTokenListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMSettableTokenListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMSettableTokenListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSettableTokenListConstructor, JSDOMWrapper>(exec, &JSDOMSettableTokenListConstructorTable, this, propertyName, slot);
}

bool JSDOMSettableTokenListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMSettableTokenListConstructor, JSDOMWrapper>(exec, &JSDOMSettableTokenListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMSettableTokenListPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMSettableTokenListPrototypeTable = { 1, 0, JSDOMSettableTokenListPrototypeTableValues, 0 };
const ClassInfo JSDOMSettableTokenListPrototype::s_info = { "DOMSettableTokenListPrototype", &JSC::JSNonFinalObject::s_info, &JSDOMSettableTokenListPrototypeTable, 0 };

JSObject* JSDOMSettableTokenListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMSettableTokenList>(exec, globalObject);
}

const ClassInfo JSDOMSettableTokenList::s_info = { "DOMSettableTokenList", &JSDOMTokenList::s_info, &JSDOMSettableTokenListTable, 0 };

JSDOMSettableTokenList::JSDOMSettableTokenList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMSettableTokenList> impl)
    : JSDOMTokenList(structure, globalObject, impl)
{
}

void JSDOMSettableTokenList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMSettableTokenList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMSettableTokenListPrototype::create(exec->globalData(), globalObject, JSDOMSettableTokenListPrototype::createStructure(exec->globalData(), globalObject, JSDOMTokenListPrototype::self(exec, globalObject)));
}

bool JSDOMSettableTokenList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDOMSettableTokenListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMSettableTokenList, Base>(exec, &JSDOMSettableTokenListTable, this, propertyName, slot);
}

bool JSDOMSettableTokenList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSDOMSettableTokenListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DOMSettableTokenList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSDOMSettableTokenList, Base>(exec, &JSDOMSettableTokenListTable, this, propertyName, descriptor);
}

bool JSDOMSettableTokenList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (propertyName < static_cast<DOMSettableTokenList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDOMSettableTokenListValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSettableTokenList* castedThis = static_cast<JSDOMSettableTokenList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSettableTokenList* imp = static_cast<DOMSettableTokenList*>(castedThis->impl());
    JSValue result = jsString(exec, imp->value());
    return result;
}


JSValue jsDOMSettableTokenListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSettableTokenList* domObject = static_cast<JSDOMSettableTokenList*>(asObject(slotBase));
    return JSDOMSettableTokenList::getConstructor(exec, domObject->globalObject());
}

void JSDOMSettableTokenList::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSDOMSettableTokenList, Base>(exec, propertyName, value, &JSDOMSettableTokenListTable, this, slot);
}

void setJSDOMSettableTokenListValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDOMSettableTokenList* castedThis = static_cast<JSDOMSettableTokenList*>(thisObject);
    DOMSettableTokenList* imp = static_cast<DOMSettableTokenList*>(castedThis->impl());
    imp->setValue(ustringToString(value.toString(exec)));
}


void JSDOMSettableTokenList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    for (unsigned i = 0; i < static_cast<DOMSettableTokenList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDOMSettableTokenList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMSettableTokenListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


JSValue JSDOMSettableTokenList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMSettableTokenList* thisObj = static_cast<JSDOMSettableTokenList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return jsStringOrNull(exec, thisObj->impl()->item(index));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMSettableTokenList* impl)
{
    return wrap<JSDOMSettableTokenList>(exec, globalObject, impl);
}


}
