/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasPattern.h"

#include "CanvasPattern.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasPattern);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasPatternTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasPatternConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasPatternTable = { 2, 1, JSCanvasPatternTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasPatternConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasPatternConstructorTable = { 1, 0, JSCanvasPatternConstructorTableValues, 0 };
class JSCanvasPatternConstructor : public DOMConstructorObject {
private:
    JSCanvasPatternConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSCanvasPatternConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSCanvasPatternConstructor* ptr = new (JSC::allocateCell<JSCanvasPatternConstructor>(*exec->heap())) JSCanvasPatternConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCanvasPatternConstructor::s_info = { "CanvasPatternConstructor", &DOMConstructorObject::s_info, &JSCanvasPatternConstructorTable, 0 };

JSCanvasPatternConstructor::JSCanvasPatternConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCanvasPatternConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCanvasPatternPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCanvasPatternConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasPatternConstructor, JSDOMWrapper>(exec, &JSCanvasPatternConstructorTable, this, propertyName, slot);
}

bool JSCanvasPatternConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasPatternConstructor, JSDOMWrapper>(exec, &JSCanvasPatternConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasPatternPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasPatternPrototypeTable = { 1, 0, JSCanvasPatternPrototypeTableValues, 0 };
const ClassInfo JSCanvasPatternPrototype::s_info = { "CanvasPatternPrototype", &JSC::JSNonFinalObject::s_info, &JSCanvasPatternPrototypeTable, 0 };

JSObject* JSCanvasPatternPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasPattern>(exec, globalObject);
}

const ClassInfo JSCanvasPattern::s_info = { "CanvasPattern", &JSDOMWrapper::s_info, &JSCanvasPatternTable, 0 };

JSCanvasPattern::JSCanvasPattern(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasPattern> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSCanvasPattern::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCanvasPattern::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCanvasPatternPrototype::create(exec->globalData(), globalObject, JSCanvasPatternPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSCanvasPattern::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSCanvasPattern, Base>(exec, &JSCanvasPatternTable, this, propertyName, slot);
}

bool JSCanvasPattern::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSCanvasPattern, Base>(exec, &JSCanvasPatternTable, this, propertyName, descriptor);
}

JSValue jsCanvasPatternConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasPattern* domObject = static_cast<JSCanvasPattern*>(asObject(slotBase));
    return JSCanvasPattern::getConstructor(exec, domObject->globalObject());
}

JSValue JSCanvasPattern::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasPatternConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CanvasPattern* impl)
{
    return wrap<JSCanvasPattern>(exec, globalObject, impl);
}

CanvasPattern* toCanvasPattern(JSC::JSValue value)
{
    return value.inherits(&JSCanvasPattern::s_info) ? static_cast<JSCanvasPattern*>(asObject(value))->impl() : 0;
}

}
